/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticAttributeStore;
import com.newrelic.agent.android.analytics.AnalyticsController;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.AnalyticsEventFactory;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.analytics.EventManagerImpl;
import com.newrelic.agent.android.analytics.NetworkEventController;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.harvest.HttpTransaction;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnalyticsControllerImpl
implements AnalyticsController {
    protected static final int MAX_ATTRIBUTES = 64;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final AnalyticsControllerImpl instance = new AnalyticsControllerImpl();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final List<String> reservedNames = new ArrayList<String>();
    private static final String NEW_RELIC_PREFIX = "newRelic";
    private static final String NR_PREFIX = "nr.";
    private final ConcurrentLinkedQueue<AnalyticAttribute> systemAttributes;
    private final ConcurrentLinkedQueue<AnalyticAttribute> userAttributes;
    private final EventManagerImpl eventManager;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final InteractionCompleteListener listener;
    private AgentImpl agentImpl;
    private AnalyticAttributeStore attributeStore;

    public static void initialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        log.verbose("AnalyticsControllerImpl.initialize invoked.");
        if (!initialized.compareAndSet(false, true)) {
            log.verbose("AnalyticsControllerImpl has already been initialized.  Bypassing..");
            return;
        }
        instance.clear();
        reservedNames.add("eventType");
        reservedNames.add("type");
        reservedNames.add("timestamp");
        reservedNames.add("category");
        reservedNames.add("accountId");
        reservedNames.add("appId");
        reservedNames.add("appName");
        reservedNames.add("uuid");
        reservedNames.add("sessionId");
        reservedNames.add("osName");
        reservedNames.add("osVersion");
        reservedNames.add("osMajorVersion");
        reservedNames.add("deviceManufacturer");
        reservedNames.add("deviceModel");
        reservedNames.add("memUsageMb");
        reservedNames.add("carrier");
        reservedNames.add("newRelicVersion");
        reservedNames.add("interactionDuration");
        reservedNames.add("install");
        reservedNames.add("upgradeFrom");
        reservedNames.add("platform");
        reservedNames.add("platformVersion");
        reservedNames.add("lastInteraction");
        reservedNames.add("osBuild");
        reservedNames.add("runTime");
        reservedNames.add("architecture");
        reservedNames.add("appBuild");
        instance.reinitialize(agentConfiguration, agentImpl);
        TraceMachine.addTraceListener(AnalyticsControllerImpl.instance.listener);
        log.info("Analytics Controller started.");
    }

    public static void shutdown() {
        TraceMachine.removeTraceListener(AnalyticsControllerImpl.instance.listener);
        instance.getEventManager().shutdown();
        initialized.compareAndSet(true, false);
    }

    private AnalyticsControllerImpl() {
        this.eventManager = new EventManagerImpl();
        this.systemAttributes = new ConcurrentLinkedQueue();
        this.userAttributes = new ConcurrentLinkedQueue();
        this.listener = new InteractionCompleteListener();
    }

    void reinitialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        this.agentImpl = agentImpl;
        this.eventManager.initialize();
        this.isEnabled.set(agentConfiguration.getEnableAnalyticsEvents());
        this.attributeStore = agentConfiguration.getAnalyticAttributeStore();
        this.loadPersistentAttributes();
        DeviceInformation deviceInformation = agentImpl.getDeviceInformation();
        String osVersion = deviceInformation.getOsVersion();
        osVersion = osVersion.replace(" ", "");
        String[] osMajorVersionArr = osVersion.split("[.:-]");
        String osMajorVersion = osMajorVersionArr.length > 0 ? osMajorVersionArr[0] : osVersion;
        EnvironmentInformation environmentInformation = agentImpl.getEnvironmentInformation();
        this.systemAttributes.add(new AnalyticAttribute("osName", deviceInformation.getOsName()));
        this.systemAttributes.add(new AnalyticAttribute("osVersion", osVersion));
        this.systemAttributes.add(new AnalyticAttribute("osBuild", deviceInformation.getOsBuild()));
        this.systemAttributes.add(new AnalyticAttribute("osMajorVersion", osMajorVersion));
        this.systemAttributes.add(new AnalyticAttribute("deviceManufacturer", deviceInformation.getManufacturer()));
        this.systemAttributes.add(new AnalyticAttribute("deviceModel", deviceInformation.getModel()));
        this.systemAttributes.add(new AnalyticAttribute("uuid", deviceInformation.getDeviceId()));
        this.systemAttributes.add(new AnalyticAttribute("carrier", agentImpl.getNetworkCarrier()));
        this.systemAttributes.add(new AnalyticAttribute("newRelicVersion", deviceInformation.getAgentVersion()));
        this.systemAttributes.add(new AnalyticAttribute("memUsageMb", environmentInformation.getMemoryUsage()));
        this.systemAttributes.add(new AnalyticAttribute("sessionId", agentConfiguration.getSessionID()));
        this.systemAttributes.add(new AnalyticAttribute("platform", agentConfiguration.getApplicationPlatform().toString()));
        this.systemAttributes.add(new AnalyticAttribute("platformVersion", agentConfiguration.getApplicationPlatformVersion()));
        this.systemAttributes.add(new AnalyticAttribute("runTime", deviceInformation.getRunTime()));
        this.systemAttributes.add(new AnalyticAttribute("architecture", deviceInformation.getArchitecture()));
        if (agentConfiguration.getCustomBuildIdentifier() != null) {
            this.systemAttributes.add(new AnalyticAttribute("appBuild", agentConfiguration.getCustomBuildIdentifier()));
        } else {
            String appBuildString = String.valueOf(Agent.getApplicationInformation().getVersionCode());
            if (!appBuildString.isEmpty()) {
                this.systemAttributes.add(new AnalyticAttribute("appBuild", appBuildString));
            }
        }
    }

    @Override
    public AnalyticAttribute getAttribute(String name) {
        log.verbose("AnalyticsControllerImpl.getAttribute - retrieving " + name);
        AnalyticAttribute attribute = this.getUserAttribute(name);
        if (attribute == null) {
            attribute = this.getSystemAttribute(name);
        }
        return attribute;
    }

    @Override
    public Set<AnalyticAttribute> getSystemAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.systemAttributes.size());
        for (AnalyticAttribute attr : this.systemAttributes) {
            attrs.add(new AnalyticAttribute(attr));
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticAttribute> getUserAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.userAttributes.size());
        for (AnalyticAttribute attr : this.userAttributes) {
            attrs.add(new AnalyticAttribute(attr));
            if (attrs.size() != 64) continue;
            break;
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticAttribute> getSessionAttributes() {
        HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>(this.getSessionAttributeCount());
        attrs.addAll(this.getSystemAttributes());
        attrs.addAll(this.getUserAttributes());
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public int getSystemAttributeCount() {
        return this.systemAttributes.size();
    }

    @Override
    public int getUserAttributeCount() {
        return Math.min(this.userAttributes.size(), 64);
    }

    @Override
    public int getSessionAttributeCount() {
        return this.systemAttributes.size() + this.userAttributes.size();
    }

    @Override
    public boolean setAttribute(String name, String value) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, String value, boolean persistent) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name) || !this.isStringValueValid(name, value)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticAttribute(name, value, persistent));
        }
        attribute.setStringValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, float value) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, float value, boolean persistent) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticAttribute(name, value, persistent));
        }
        attribute.setFloatValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, boolean value) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, boolean value, boolean persistent) {
        log.verbose("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticAttribute(name, value, persistent));
        }
        attribute.setBooleanValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    public boolean addAttributeUnchecked(AnalyticAttribute attribute, boolean persistent) {
        log.verbose("AnalyticsControllerImpl.setAttributeUnchecked - " + attribute.getName() + ": " + attribute.getStringValue() + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        String name = attribute.getName();
        if (!this.isNameValid(name)) {
            return false;
        }
        if (attribute.isStringAttribute() && !this.isStringValueValid(name, attribute.getStringValue())) {
            return false;
        }
        AnalyticAttribute cachedAttribute = this.getSystemAttribute(name);
        if (cachedAttribute == null) {
            this.systemAttributes.add(attribute);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            switch (attribute.getAttributeDataType()) {
                case STRING: {
                    cachedAttribute.setStringValue(attribute.getStringValue());
                    break;
                }
                case FLOAT: {
                    cachedAttribute.setFloatValue(attribute.getFloatValue());
                    break;
                }
                case BOOLEAN: {
                    cachedAttribute.setBooleanValue(attribute.getBooleanValue());
                }
            }
            cachedAttribute.setPersistent(persistent);
            if (cachedAttribute.isPersistent()) {
                if (!this.attributeStore.store(cachedAttribute)) {
                    log.error("Failed to store attribute " + cachedAttribute + " to attribute store.");
                    return false;
                }
            } else {
                this.attributeStore.delete(cachedAttribute);
            }
        }
        return true;
    }

    @Override
    public boolean incrementAttribute(String name, float value) {
        log.verbose("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value);
        return this.incrementAttribute(name, value, true);
    }

    @Override
    public boolean incrementAttribute(String name, float value, boolean persistent) {
        log.verbose("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute != null && attribute.isFloatAttribute()) {
            attribute.setFloatValue(attribute.getFloatValue() + value);
            attribute.setPersistent(persistent);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            if (attribute == null) {
                return this.addNewUserAttribute(new AnalyticAttribute(name, value, persistent));
            }
            log.warning("Cannot increment attribute " + name + ": the attribute is already defined as a non-float value.");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAttribute(String name) {
        log.verbose("AnalyticsControllerImpl.removeAttribute - " + name);
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        AnalyticAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            this.userAttributes.remove(attribute);
            if (attribute.isPersistent()) {
                this.attributeStore.delete(attribute);
            }
        }
        return true;
    }

    @Override
    public boolean removeAllAttributes() {
        log.verbose("AnalyticsControllerImpl.removeAttributes - ");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        this.attributeStore.clear();
        this.userAttributes.clear();
        return false;
    }

    @Override
    public boolean addEvent(String name, Set<AnalyticAttribute> eventAttributes) {
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", eventAttributes);
    }

    @Override
    public boolean addEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticAttribute> eventAttributes) {
        log.verbose("AnalyticsControllerImpl.addEvent - " + name + ": category=" + (Object)((Object)eventCategory) + ", eventType: " + eventType + ", eventAttributes:" + eventAttributes);
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticAttribute> validatedAttributes = new HashSet<AnalyticAttribute>();
        for (AnalyticAttribute attribute : eventAttributes) {
            if (!this.isAttributeNameValid(attribute.getName())) continue;
            validatedAttributes.add(attribute);
        }
        AnalyticsEvent event = AnalyticsEventFactory.createEvent(name, eventCategory, eventType, validatedAttributes);
        return this.addEvent(event);
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticAttribute> sessionAttributes = new HashSet<AnalyticAttribute>();
        long sessionDuration = this.agentImpl.getSessionDurationMillis();
        if (0L == sessionDuration) {
            log.error("Harvest instance is not running! Session duration will be invalid");
        } else {
            sessionAttributes.add(new AnalyticAttribute("timeSinceLoad", (float)sessionDuration / 1000.0f));
            event.addAttributes(sessionAttributes);
        }
        return this.eventManager.addEvent(event);
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.eventManager.getMaxEventPoolSize();
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.eventManager.setMaxEventPoolSize(maxSize);
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.eventManager.setMaxEventBufferTime(maxBufferTimeInSec);
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.eventManager.getMaxEventBufferTime();
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public static AnalyticsControllerImpl getInstance() {
        return instance;
    }

    void loadPersistentAttributes() {
        log.verbose("AnalyticsControllerImpl.loadPersistentAttributes - loading userAttributes from the attribute store...");
        List<AnalyticAttribute> storedAttrs = this.attributeStore.fetchAll();
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes - found " + storedAttrs.size() + " userAttributes in the attribute store...");
        int size = this.userAttributes.size();
        for (AnalyticAttribute attr : storedAttrs) {
            if (this.userAttributes.contains(attr) || size > 64) continue;
            this.userAttributes.add(attr);
            ++size;
        }
    }

    private AnalyticAttribute getSystemAttribute(String name) {
        AnalyticAttribute attribute = null;
        for (AnalyticAttribute nextAttribute : this.systemAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private AnalyticAttribute getUserAttribute(String name) {
        AnalyticAttribute attribute = null;
        for (AnalyticAttribute nextAttribute : this.userAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private void clear() {
        log.verbose("AnalyticsControllerImpl.clear - clearing out attributes and events");
        this.systemAttributes.clear();
        this.userAttributes.clear();
        this.eventManager.empty();
    }

    private boolean isAttributeNameValid(String name) {
        boolean valid = this.isNameValid(name);
        if (valid) {
            boolean bl = valid = !this.isNameReserved(name);
            if (!valid) {
                log.error("Attribute name " + name + " is reserved for internal use and will be ignored.");
            }
        }
        return valid;
    }

    private boolean isNameValid(String name) {
        boolean valid;
        boolean bl = valid = name != null && !name.equals("") && name.length() < 256;
        if (!valid) {
            log.error("Attribute name " + name + " is null, empty, or exceeds the maximum length of " + 256 + " characters.");
        }
        return valid;
    }

    private boolean isStringValueValid(String name, String value) {
        boolean valid;
        boolean bl = valid = value != null && !value.equals("") && value.getBytes().length < 4096;
        if (!valid) {
            log.error("Attribute value for name " + name + " is null, empty, or exceeds the maximum length of " + 4096 + " bytes.");
        }
        return valid;
    }

    private boolean isNameReserved(String name) {
        if (reservedNames.contains(name)) {
            log.verbose("Name " + name + " is in the reserved names list.");
            return true;
        }
        if (name.startsWith(NEW_RELIC_PREFIX)) {
            log.verbose("Name " + name + " starts with reserved prefix " + NEW_RELIC_PREFIX);
            return true;
        }
        if (name.startsWith(NR_PREFIX)) {
            log.verbose("Name " + name + " starts with reserved prefix " + NR_PREFIX);
            return true;
        }
        return false;
    }

    private AnalyticAttribute createAttribute(String key, Object value) {
        try {
            if (value instanceof String) {
                return new AnalyticAttribute(key, String.valueOf(value));
            }
            if (value instanceof Float) {
                return new AnalyticAttribute(key, Float.valueOf(((Float)value).floatValue()).floatValue());
            }
            if (value instanceof Double) {
                return new AnalyticAttribute(key, Float.valueOf(((Double)value).floatValue()).floatValue());
            }
            if (value instanceof Integer) {
                return new AnalyticAttribute(key, Float.valueOf(((Integer)value).intValue()).floatValue());
            }
            if (value instanceof Short) {
                return new AnalyticAttribute(key, Float.valueOf(((Short)value).shortValue()).floatValue());
            }
            if (value instanceof Long) {
                return new AnalyticAttribute(key, Float.valueOf(((Long)value).longValue()).floatValue());
            }
            if (value instanceof BigDecimal) {
                return new AnalyticAttribute(key, Float.valueOf(((BigDecimal)value).floatValue()).floatValue());
            }
            if (value instanceof BigInteger) {
                return new AnalyticAttribute(key, Float.valueOf(((BigInteger)value).floatValue()).floatValue());
            }
            if (value instanceof Boolean) {
                return new AnalyticAttribute(key, (Boolean)value);
            }
            log.error("Unsupported event attribute type for key [" + key + "]: " + value.getClass().getName());
            return null;
        }
        catch (ClassCastException e) {
            log.error(String.format("Error casting attribute [%s] to String or Float: ", key), e);
            return null;
        }
    }

    public boolean recordCustomEvent(String eventType, Map<String, Object> eventAttributes) {
        log.verbose("AnalyticsControllerImpl.recordCustomEvent - " + eventType + ": " + eventAttributes.size() + " attributes");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (this.eventManager.isEventTypeReserved(eventType) || !this.eventManager.isEventTypeValid(eventType)) {
            return false;
        }
        String eventName = eventType;
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr != null) {
                    String name;
                    if (attr.getName().equals("name") && (name = attr.getStringValue()) != null && !name.isEmpty()) {
                        eventName = attr.getStringValue();
                    }
                    attributes.add(attr);
                    continue;
                }
                return false;
            }
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", eventType), e);
        }
        return this.addEvent(eventName, AnalyticsEventCategory.Custom, eventType, attributes);
    }

    public boolean recordBreadcrumb(String name, Map<String, Object> eventAttributes) {
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr != null) {
                    attributes.add(attr);
                    continue;
                }
                return false;
            }
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
        }
        return this.addEvent(name, AnalyticsEventCategory.Breadcrumb, "MobileBreadcrumb", attributes);
    }

    public boolean recordEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Map<String, Object> eventAttributes) {
        log.verbose("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.eventManager.isEventTypeValid(eventType)) {
            return false;
        }
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) {
                    return false;
                }
                attributes.add(attr);
            }
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
        }
        return this.addEvent(name, eventCategory, eventType, attributes);
    }

    @Override
    public boolean recordEvent(String name, Map<String, Object> eventAttributes) {
        log.verbose("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) {
                    return false;
                }
                attributes.add(attr);
            }
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
        }
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", attributes);
    }

    void createHttpErrorEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createHttpErrorEvent(txn);
        }
    }

    void createNetworkFailureEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkFailureEvent(txn);
        }
    }

    void createNetworkRequestEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkRequestEvent(txn);
        }
    }

    public void createNetworkRequestEvents(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            if (this.isHttpError(txn)) {
                NetworkEventController.createHttpErrorEvent(txn);
            } else if (this.isNetworkFailure(txn)) {
                NetworkEventController.createNetworkFailureEvent(txn);
            } else if (this.isSuccessfulRequest(txn)) {
                NetworkEventController.createNetworkRequestEvent(txn);
            }
        }
    }

    private boolean isNetworkFailure(HttpTransaction txn) {
        return txn.getErrorCode() != 0;
    }

    private boolean isHttpError(HttpTransaction txn) {
        return (long)txn.getStatusCode() >= 400L;
    }

    private boolean isSuccessfulRequest(HttpTransaction txn) {
        return txn.getStatusCode() > 0 && txn.getStatusCode() < 400;
    }

    private boolean isInitializedAndEnabled() {
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled.set(enabled);
    }

    private boolean addNewUserAttribute(AnalyticAttribute attribute) {
        if (this.userAttributes.size() < 64) {
            this.userAttributes.add(attribute);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            log.warning("Attribute limit exceeded: at most 64 are allowed.");
            log.debug("Currently defined attributes:");
            for (AnalyticAttribute attr : this.userAttributes) {
                log.debug("\t" + attr.getName() + ": " + attr.valueAsString());
            }
        }
        return true;
    }

    class InteractionCompleteListener
    implements TraceLifecycleAware {
        InteractionCompleteListener() {
        }

        @Override
        public void onEnterMethod() {
        }

        @Override
        public void onExitMethod() {
        }

        @Override
        public void onTraceStart(ActivityTrace activityTrace) {
            AnalyticAttribute lastInteraction = new AnalyticAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        @Override
        public void onTraceComplete(ActivityTrace activityTrace) {
            log.verbose("AnalyticsControllerImpl.InteractionCompleteListener.onTraceComplete invoke.");
            AnalyticsEvent event = this.createTraceEvent(activityTrace);
            AnalyticsControllerImpl.getInstance().addEvent(event);
        }

        @Override
        public void onTraceRename(ActivityTrace activityTrace) {
            AnalyticAttribute lastInteraction = new AnalyticAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        private AnalyticsEvent createTraceEvent(ActivityTrace activityTrace) {
            float durationInSec = activityTrace.rootTrace.getDurationAsSeconds();
            HashSet<AnalyticAttribute> attrs = new HashSet<AnalyticAttribute>();
            attrs.add(new AnalyticAttribute("interactionDuration", durationInSec));
            return AnalyticsEventFactory.createEvent(activityTrace.rootTrace.displayName, AnalyticsEventCategory.Interaction, "Mobile", attrs);
        }
    }
}

