/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.HttpError;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.com.google.gson.JsonArray;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class HttpErrors
extends HarvestableArray {
    private final Collection<HttpError> httpErrors = new CopyOnWriteArrayList<HttpError>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpError(HttpError httpError) {
        HttpError httpError2 = httpError;
        synchronized (httpError2) {
            for (HttpError error : this.httpErrors) {
                if (!httpError.getHash().equals(error.getHash())) continue;
                error.incrementCount();
                return;
            }
            this.httpErrors.add(httpError);
        }
    }

    public synchronized void removeHttpError(HttpError error) {
        this.httpErrors.remove(error);
    }

    public void clear() {
        this.httpErrors.clear();
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray();
        for (HttpError httpError : this.httpErrors) {
            array.add(httpError.asJson());
        }
        return array;
    }

    public Collection<HttpError> getHttpErrors() {
        return this.httpErrors;
    }

    public int count() {
        return this.httpErrors.size();
    }
}

