/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.HttpURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.HttpsURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.WrapReturn;
import com.newrelic.agent.android.instrumentation.httpclient.ResponseHandlerImpl;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class HttpInstrumentation {
    private HttpInstrumentation() {
    }

    @WrapReturn(className="java/net/URL", methodName="openConnection", methodDesc="()Ljava/net/URLConnection;")
    public static URLConnection openConnection(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new HttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    @WrapReturn(className="java.net.URL", methodName="openConnection", methodDesc="(Ljava/net/Proxy;)Ljava/net/URLConnection;")
    public static URLConnection openConnectionWithProxy(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)connection);
        }
        if (connection instanceof HttpURLConnection) {
            return new HttpURLConnectionExtension((HttpURLConnection)connection);
        }
        return connection;
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        try {
            return HttpInstrumentation.delegate(httpClient.execute(target, HttpInstrumentation.delegate(target, request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        try {
            return (T)httpClient.execute(target, HttpInstrumentation.delegate(target, request, transactionState), HttpInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            HttpInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        try {
            return (T)httpClient.execute(target, HttpInstrumentation.delegate(target, request, transactionState), HttpInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            HttpInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        try {
            return HttpInstrumentation.delegate(httpClient.execute(target, HttpInstrumentation.delegate(target, request, transactionState)), transactionState);
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        try {
            return HttpInstrumentation.delegate(httpClient.execute(HttpInstrumentation.delegate(request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        try {
            return (T)httpClient.execute(HttpInstrumentation.delegate(request, transactionState), HttpInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            HttpInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        try {
            return (T)httpClient.execute(HttpInstrumentation.delegate(request, transactionState), HttpInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            HttpInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        try {
            return HttpInstrumentation.delegate(httpClient.execute(HttpInstrumentation.delegate(request, transactionState)), transactionState);
        }
        catch (IOException e) {
            HttpInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    protected static void httpClientError(TransactionState transactionState, Exception e) {
        if (!transactionState.isComplete()) {
            TransactionStateUtil.setErrorCodeFromException(transactionState, e);
            TransactionData transactionData = transactionState.end();
            if (transactionData != null) {
                transactionData.setResponseBody(e.toString());
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }

    private static HttpUriRequest delegate(HttpUriRequest request, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, request);
    }

    private static HttpRequest delegate(HttpHost host, HttpRequest request, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, host, request);
    }

    private static HttpResponse delegate(HttpResponse response, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, response);
    }

    private static <T> ResponseHandler<? extends T> delegate(ResponseHandler<? extends T> handler, TransactionState transactionState) {
        return ResponseHandlerImpl.wrap(handler, transactionState);
    }
}

