/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.payload;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.stats.TicToc;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.Callable;

public abstract class PayloadSender
implements Callable<PayloadSender> {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected Payload payload;
    protected final AgentConfiguration agentConfiguration;
    protected final TicToc timer;
    protected int responseCode;

    public PayloadSender(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        this.timer = new TicToc();
        this.responseCode = 0;
    }

    public PayloadSender(Payload payload, AgentConfiguration agentConfiguration) {
        this(agentConfiguration);
        this.payload = payload;
    }

    public PayloadSender(byte[] payloadBytes, AgentConfiguration agentConfiguration) {
        this(agentConfiguration);
        this.payload = new Payload(payloadBytes);
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payloadBytes) {
        this.payload.putBytes(payloadBytes);
    }

    protected abstract HttpURLConnection getConnection() throws IOException;

    protected void onRequestResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: {
                InputStream responseInputStream = connection.getInputStream();
                if (responseInputStream == null) break;
                String responseString = this.readStream(responseInputStream, responseInputStream.available());
                this.onRequestContent(responseString);
                break;
            }
            case 500: {
                this.onFailedUpload("Payload [" + this.payload.getUuid() + "] was rejected and will be deleted - Response code [" + responseCode + "]");
                break;
            }
            default: {
                this.onFailedUpload("Something went wrong while submitting the payload [" + this.payload.getUuid() + "] (will try again later) - Response code [" + responseCode + "]");
            }
        }
        log.debug("Payload [" + this.payload.getUuid() + "] delivery took " + this.timer.toc() + "ms");
    }

    protected void onRequestContent(String responseString) {
    }

    protected void onRequestException(Exception e) {
        this.onFailedUpload("Payload [" + this.payload.getUuid() + "] upload failed: " + e);
    }

    protected void onFailedUpload(String errorMsg) {
        log.error(errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PayloadSender call() throws Exception {
        try {
            this.timer.tic();
            HttpURLConnection connection = this.getConnection();
            try {
                connection.connect();
                try (BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());){
                    ((OutputStream)out).write(this.payload.getBytes());
                }
                this.responseCode = connection.getResponseCode();
                this.onRequestResponse(connection);
            }
            catch (Exception e) {
                this.onRequestException(e);
            }
            finally {
                connection.disconnect();
            }
            return this;
        }
        catch (Exception e) {
            this.onFailedUpload("Unable to upload payload [" + this.payload.getUuid() + "]  to New Relic, will try again later. " + e);
            return this;
        }
    }

    protected String getProtocol() {
        return this.agentConfiguration.useSsl() ? "https://" : "http://";
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    protected String readStream(InputStream stream, int maxLength) throws IOException {
        String result = null;
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        char[] buffer = new char[maxLength];
        int numChars = 0;
        int readSize = 0;
        while (numChars < maxLength && readSize != -1) {
            readSize = reader.read(buffer, numChars += readSize, buffer.length - numChars);
        }
        if (numChars != -1) {
            numChars = Math.min(numChars, maxLength);
            result = new String(buffer, 0, numChars);
        }
        return result;
    }

    public boolean isSuccessfulResponse() {
        switch (this.responseCode) {
            case 200: 
            case 500: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PayloadSender) {
            return this.getPayload() == ((PayloadSender)object).getPayload();
        }
        return false;
    }

    protected boolean shouldUploadOpportunistically() {
        return Agent.hasReachableNetworkConnection(null);
    }

    public boolean shouldRetry() {
        return false;
    }

    public static interface CompletionHandler {
        public void onResponse(PayloadSender var1);

        public void onException(PayloadSender var1, Exception var2);
    }
}

