/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticAttributeStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedPrefsAnalyticAttributeStore
extends SharedPrefsStore
implements AnalyticAttributeStore {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String STORE_FILE = "NRAnalyticAttributeStore";

    public SharedPrefsAnalyticAttributeStore(Context context) {
        super(context, STORE_FILE);
    }

    public SharedPrefsAnalyticAttributeStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(AnalyticAttribute attribute) {
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            if (attribute.isPersistent()) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                switch (attribute.getAttributeDataType()) {
                    case STRING: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getStringValue());
                        editor.putString(attribute.getName(), attribute.getStringValue());
                        break;
                    }
                    case FLOAT: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getFloatValue());
                        editor.putFloat(attribute.getName(), attribute.getFloatValue());
                        break;
                    }
                    case BOOLEAN: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getBooleanValue());
                        editor.putBoolean(attribute.getName(), attribute.getBooleanValue());
                        break;
                    }
                    default: {
                        log.error("SharedPrefsAnalyticAttributeStore.store - unsupported analytic attribute data type" + attribute.getName());
                        return false;
                    }
                }
                return this.applyOrCommitEditor(editor);
            }
        }
        return false;
    }

    @Override
    public List<AnalyticAttribute> fetchAll() {
        ArrayList<AnalyticAttribute> analyticAttributeArrayList = new ArrayList<AnalyticAttribute>();
        Map storedAttributes = this.sharedPrefs.getAll();
        for (Map.Entry entry : storedAttributes.entrySet()) {
            log.verbose("SharedPrefsAnalyticAttributeStore.fetchAll - found analytic attribute " + entry.getKey() + "=" + entry.getValue());
            if (entry.getValue() instanceof String) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), entry.getValue().toString(), true));
                continue;
            }
            if (entry.getValue() instanceof Float) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), Float.valueOf(entry.getValue().toString()).floatValue(), true));
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), Boolean.valueOf(entry.getValue().toString()), true));
                continue;
            }
            log.error("SharedPrefsAnalyticAttributeStore.fetchAll - unsupported analytic attribute " + entry.getKey() + "=" + entry.getValue());
        }
        return analyticAttributeArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(AnalyticAttribute attribute) {
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            log.verbose("SharedPrefsAnalyticAttributeStore.delete - deleting attribute " + attribute.getName());
            super.delete(attribute.getName());
        }
    }
}

