/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.agentdata;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.agentdata.AgentDataSender;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class AgentDataReporter
extends PayloadReporter
implements HarvestLifecycleAware {
    protected static final AtomicReference<AgentDataReporter> instance = new AtomicReference<Object>(null);
    private static boolean reportExceptions = false;
    protected final PayloadStore<Payload> payloadStore;
    protected final Callable reportCachedAgentDataCallable = new Callable(){

        public Object call() throws Exception {
            AgentDataReporter.this.reportCachedAgentData();
            return null;
        }
    };

    public static AgentDataReporter getInstance() {
        return instance.get();
    }

    public static AgentDataReporter initialize(AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new AgentDataReporter(agentConfiguration));
        reportExceptions = agentConfiguration.getReportHandledExceptions();
        return instance.get();
    }

    public static void shutdown() {
        if (AgentDataReporter.isInitialized()) {
            try {
                instance.get().stop();
            }
            finally {
                instance.set(null);
            }
        }
    }

    public static boolean reportAgentData(byte[] bytes) {
        boolean reported = false;
        if (AgentDataReporter.isInitialized()) {
            if (reportExceptions) {
                Payload payload = new Payload(bytes);
                instance.get().storeAndReportAgentData(payload);
                reported = true;
            }
        } else {
            log.error("AgentDataReporter not initialized");
        }
        return reported;
    }

    protected static boolean isInitialized() {
        return instance.get() != null;
    }

    protected AgentDataReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.payloadStore = agentConfiguration.getPayloadStore();
        this.isEnabled.set(agentConfiguration.getReportHandledExceptions());
    }

    @Override
    public void start() {
        if (PayloadController.isInitialized()) {
            if (this.isEnabled() && this.isStarted.compareAndSet(false, true)) {
                PayloadController.submitCallable(this.reportCachedAgentDataCallable);
                Harvest.addHarvestListener(this);
            }
        } else {
            log.error("AgentDataReporter.start(): Must initialize PayloadController first.");
        }
    }

    @Override
    public void stop() {
        Harvest.removeHarvestListener(this);
    }

    protected void reportCachedAgentData() {
        if (AgentDataReporter.isInitialized()) {
            if (this.payloadStore != null) {
                for (Payload payload : this.payloadStore.fetchAll()) {
                    if (this.isPayloadStale(payload)) continue;
                    this.reportAgentData(payload);
                }
            }
        } else {
            log.error("AgentDataReporter not initialized");
        }
    }

    protected Future reportAgentData(Payload payload) {
        Future future = null;
        AgentDataSender payloadSender = new AgentDataSender(payload, this.getAgentConfiguration());
        future = PayloadController.submitPayload(payloadSender, new PayloadSender.CompletionHandler(){

            @Override
            public void onResponse(PayloadSender payloadSender) {
                if (payloadSender.isSuccessfulResponse() && AgentDataReporter.this.payloadStore != null) {
                    AgentDataReporter.this.payloadStore.delete(payloadSender.getPayload());
                }
            }

            @Override
            public void onException(PayloadSender payloadSender, Exception e) {
                log.error("AgentDataReporter.reportAgentData(Payload): " + e);
            }
        });
        return future;
    }

    public Future storeAndReportAgentData(Payload payload) {
        if (this.payloadStore != null && payload.isPersisted() && this.payloadStore.store(payload)) {
            payload.setPersisted(false);
        }
        return this.reportAgentData(payload);
    }

    private boolean isPayloadStale(Payload payload) {
        if (payload.isStale(this.agentConfiguration.getPayloadTTL())) {
            this.payloadStore.delete(payload);
            log.info("Payload [" + payload.getUuid() + "] has become stale, and has been removed");
            StatsEngine.get().inc("Supportability/AgentHealth/Payload/Removed/Stale");
            return true;
        }
        return false;
    }

    private byte[] submitBatchedPayload(final List<Payload> payloads) {
        if (!payloads.isEmpty()) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Iterator<Payload> iter = payloads.iterator();
            while (iter.hasNext()) {
                try {
                    Payload payload = iter.next();
                    output.write(payload.getBytes());
                }
                catch (Exception payload) {}
            }
            FlatBufferBuilder flat = new FlatBufferBuilder(ByteBuffer.wrap(output.toByteArray()));
            ByteBuffer byteBuffer = flat.dataBuffer().slice();
            byte[] modifiedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(modifiedBytes);
            AgentDataSender agentDataSender = new AgentDataSender(byteBuffer.array(), AgentDataReporter.instance.get().agentConfiguration);
            PayloadController.submitPayload(agentDataSender, new PayloadSender.CompletionHandler(){

                @Override
                public void onResponse(PayloadSender payloadSender) {
                    if (payloadSender.isSuccessfulResponse() && AgentDataReporter.this.payloadStore != null) {
                        for (Payload payload : payloads) {
                            AgentDataReporter.this.payloadStore.delete(payload);
                        }
                    }
                }

                @Override
                public void onException(PayloadSender payloadSender, Exception e) {
                    log.error("AgentDataReporter.submitBatchedPayload(List<Payload>): " + e);
                }
            });
        }
        return null;
    }

    @Override
    public void onHarvestStart() {
    }

    @Override
    public void onHarvestStop() {
    }

    @Override
    public void onHarvestBefore() {
    }

    @Override
    public void onHarvest() {
        PayloadController.submitCallable(this.reportCachedAgentDataCallable);
    }

    @Override
    public void onHarvestFinalize() {
    }

    @Override
    public void onHarvestError() {
    }

    @Override
    public void onHarvestSendFailed() {
    }

    @Override
    public void onHarvestComplete() {
    }

    @Override
    public void onHarvestConnected() {
    }

    @Override
    public void onHarvestDisconnected() {
    }

    @Override
    public void onHarvestDisabled() {
    }
}

