/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.BreadcrumbEvent;
import com.newrelic.agent.android.analytics.CrashEvent;
import com.newrelic.agent.android.analytics.CustomEvent;
import com.newrelic.agent.android.analytics.InteractionEvent;
import com.newrelic.agent.android.analytics.NetworkRequestErrorEvent;
import com.newrelic.agent.android.analytics.NetworkRequestEvent;
import com.newrelic.agent.android.analytics.SessionEvent;
import com.newrelic.agent.android.analytics.UserActionEvent;
import java.util.Set;

class AnalyticsEventFactory {
    static AnalyticsEvent createEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticAttribute> eventAttributes) {
        AnalyticsEvent event = null;
        switch (eventCategory) {
            case Session: {
                event = new SessionEvent(eventAttributes);
                break;
            }
            case RequestError: {
                event = new NetworkRequestErrorEvent(eventAttributes);
                break;
            }
            case Interaction: {
                event = new InteractionEvent(name, eventAttributes);
                break;
            }
            case Crash: {
                event = new CrashEvent(name, eventAttributes);
                break;
            }
            case Custom: {
                event = new CustomEvent(name, eventType, eventAttributes);
                break;
            }
            case Breadcrumb: {
                event = new BreadcrumbEvent(name, eventAttributes);
                break;
            }
            case NetworkRequest: {
                event = new NetworkRequestEvent(eventAttributes);
                break;
            }
            case UserAction: {
                event = new UserActionEvent(name, eventAttributes);
            }
        }
        return event;
    }

    private AnalyticsEventFactory() {
    }
}

