/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.connectivity;

import com.newrelic.agent.android.connectivity.CatPayload;
import com.newrelic.agent.android.connectivity.ConnectivityFacade;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import java.util.concurrent.atomic.AtomicReference;

public class CatFacade
implements ConnectivityFacade,
HarvestLifecycleAware {
    private HarvestConfiguration configuration = HarvestConfiguration.getDefaultHarvestConfiguration();
    private AtomicReference<String> atomicTripId = new AtomicReference<String>("");
    private AtomicReference<String> atomicParentId = new AtomicReference<String>("");
    private static final CatFacade instance = new CatFacade();

    @Override
    public synchronized CatPayload startTrip() {
        this.atomicTripId.set(this.generateRandom16CharHex());
        this.atomicParentId.set(this.generateRandom16CharHex());
        CatPayload payload = new CatPayload(this.configuration.getAccount_id(), this.configuration.getApplication_id(), this.atomicParentId.get(), this.atomicParentId.get(), this.atomicTripId.get());
        return payload;
    }

    @Override
    public CatPayload createCatPayload() {
        String id = this.generateRandom16CharHex();
        String accountId = this.configuration.getAccount_id();
        String appId = this.configuration.getApplication_id();
        return new CatPayload(accountId, appId, id, this.atomicParentId.get(), this.atomicTripId.get());
    }

    public static CatFacade getInstance() {
        return instance;
    }

    private Long randomNumber() {
        return (long)Math.floor(Math.random() * 65535.0);
    }

    private String generateRandom16CharHex() {
        return Long.toHexString(this.randomNumber()) + Long.toHexString(this.randomNumber()) + Long.toHexString(this.randomNumber()) + Long.toHexString(this.randomNumber());
    }

    @Override
    public void onHarvestStart() {
    }

    @Override
    public void onHarvestStop() {
    }

    @Override
    public void onHarvestBefore() {
    }

    @Override
    public void onHarvest() {
    }

    @Override
    public void onHarvestFinalize() {
    }

    @Override
    public void onHarvestError() {
    }

    @Override
    public void onHarvestSendFailed() {
    }

    @Override
    public void onHarvestComplete() {
    }

    @Override
    public void onHarvestConnected() {
        this.configuration = Harvest.getHarvestConfiguration();
    }

    @Override
    public void onHarvestDisconnected() {
    }

    @Override
    public void onHarvestDisabled() {
    }

    public void setConfiguration(HarvestConfiguration configuration) {
        this.configuration = configuration;
    }
}

