/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.connectivity;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class CatPayload {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final Gson gson = new Gson();
    public static final String CONNECTIVITY_TRACE_HEADER = "X-NewRelic-Trace";
    public static final String DISTRIBUTED_TRACING_VERSION_KEY = "v";
    public static final String DATA_KEY = "d";
    public static final String PAYLOAD_TYPE_KEY = "ty";
    public static final String ACCOUNT_ID_KEY = "ac";
    public static final String APP_ID_KEY = "ap";
    public static final String PAYLOAD_ID_KEY = "id";
    public static final String TRIP_ID_KEY = "tr";
    public static final String PARENT_ID_KEY = "pa";
    public static final String TIMESTAMP_KEY = "ti";
    private final int majorVersion = 0;
    private final int minorVersion = 1;
    private final String callerType = "Mobile";
    private String data;
    private String callerAccountId;
    private String callerAppId;
    private String id;
    private String tripId;
    private String parentId;
    private long timestampMs = System.currentTimeMillis();

    CatPayload(String callerAccountId, String callerAppId, String id, String parentId, String tripId) {
        this.callerAccountId = callerAccountId;
        this.callerAppId = callerAppId;
        this.id = id;
        this.parentId = parentId;
        this.tripId = tripId;
    }

    public Map<String, Object> asMapForRequest() {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("nr.guid", this.id);
        payloadMap.put("nr.tripId", this.tripId);
        payloadMap.put("nr.parentId", this.parentId);
        return payloadMap;
    }

    public Map<String, Object> asMapForUserAction() {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("nr.guid", this.id);
        payloadMap.put("nr.tripId", this.tripId);
        return payloadMap;
    }

    public JsonObject asJson() {
        JsonObject payload = new JsonObject();
        JsonArray version = new JsonArray();
        JsonObject jsonData = new JsonObject();
        try {
            version.add(new JsonPrimitive(0));
            version.add(new JsonPrimitive(1));
            jsonData.add(PAYLOAD_TYPE_KEY, new JsonPrimitive("Mobile"));
            jsonData.add(ACCOUNT_ID_KEY, new JsonPrimitive(this.callerAccountId));
            jsonData.add(APP_ID_KEY, new JsonPrimitive(this.callerAppId));
            jsonData.add(PAYLOAD_ID_KEY, new JsonPrimitive(this.id));
            jsonData.add(TRIP_ID_KEY, new JsonPrimitive(this.tripId));
            jsonData.add(PARENT_ID_KEY, new JsonPrimitive(this.parentId));
            jsonData.add(TIMESTAMP_KEY, new JsonPrimitive(this.timestampMs));
            payload.add(DISTRIBUTED_TRACING_VERSION_KEY, version);
            payload.add(DATA_KEY, jsonData);
        }
        catch (Exception e) {
            log.error("Unable to create payload asJSON", e);
        }
        return payload;
    }

    public String asBase64Json() {
        try {
            return Agent.getEncoder().encodeNoWrap(this.asJson().toString().getBytes());
        }
        catch (Exception e) {
            AgentLogManager.getAgentLog().error(e.toString());
            return "";
        }
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String tripId) {
        this.tripId = tripId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

