/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AnalyticsEvent
extends HarvestableObject {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    private String name;
    private long timestamp;
    private AnalyticsEventCategory category;
    private String eventType;
    private Set<AnalyticAttribute> attributeSet = Collections.synchronizedSet(new HashSet());

    protected AnalyticsEvent(String name) {
        this(name, AnalyticsEventCategory.Custom, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category) {
        this(name, category, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category, String eventType, Set<AnalyticAttribute> initialAttributeSet) {
        this(name, category, eventType, System.currentTimeMillis(), initialAttributeSet);
    }

    private AnalyticsEvent(String name, AnalyticsEventCategory category, String eventType, long timeStamp, Set<AnalyticAttribute> initialAttributeSet) {
        this.name = name;
        this.category = category == null ? AnalyticsEventCategory.Custom : category;
        this.eventType = eventType == null ? "Mobile" : eventType;
        this.timestamp = timeStamp;
        if (initialAttributeSet != null) {
            for (AnalyticAttribute attribute : initialAttributeSet) {
                this.attributeSet.add(new AnalyticAttribute(attribute));
            }
        }
        if (name != null) {
            this.attributeSet.add(new AnalyticAttribute("name", this.name));
        }
        this.attributeSet.add(new AnalyticAttribute("timestamp", String.valueOf(this.timestamp)));
        this.attributeSet.add(new AnalyticAttribute("category", this.category.name()));
        this.attributeSet.add(new AnalyticAttribute("eventType", this.eventType));
    }

    public void addAttributes(Set<AnalyticAttribute> attributeSet) {
        if (attributeSet != null) {
            for (AnalyticAttribute attribute : attributeSet) {
                if (this.attributeSet.add(attribute)) continue;
                log.error("Failed to add attribute " + attribute.getName() + " to event " + this.getName() + ": the event already contains that attribute.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AnalyticsEventCategory getCategory() {
        return this.category;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        AnalyticsEvent analyticsEvent = this;
        synchronized (analyticsEvent) {
            for (AnalyticAttribute attribute : this.attributeSet) {
                data.add(attribute.getName(), attribute.asJsonElement());
            }
        }
        return data;
    }

    public Collection<AnalyticAttribute> getAttributeSet() {
        return Collections.unmodifiableCollection(this.attributeSet);
    }

    public static AnalyticsEvent newFromJson(JsonObject analyticsEventJson) {
        Iterator<Map.Entry<String, JsonElement>> entry = analyticsEventJson.entrySet().iterator();
        String name = null;
        String eventType = null;
        AnalyticsEventCategory category = null;
        long timestamp = 0L;
        HashSet<AnalyticAttribute> attributeSet = new HashSet<AnalyticAttribute>();
        while (entry.hasNext()) {
            Map.Entry<String, JsonElement> elem = entry.next();
            String key = elem.getKey();
            if (key.equalsIgnoreCase("name")) {
                name = elem.getValue().getAsString();
                continue;
            }
            if (key.equalsIgnoreCase("category")) {
                category = AnalyticsEventCategory.fromString(elem.getValue().getAsString());
                continue;
            }
            if (key.equalsIgnoreCase("eventType")) {
                eventType = elem.getValue().getAsString();
                continue;
            }
            if (key.equalsIgnoreCase("timestamp")) {
                timestamp = elem.getValue().getAsLong();
                continue;
            }
            JsonPrimitive value = elem.getValue().getAsJsonPrimitive();
            if (value.isString()) {
                attributeSet.add(new AnalyticAttribute(key, value.getAsString(), false));
                continue;
            }
            if (value.isBoolean()) {
                attributeSet.add(new AnalyticAttribute(key, value.getAsBoolean(), false));
                continue;
            }
            if (!value.isNumber()) continue;
            attributeSet.add(new AnalyticAttribute(key, value.getAsFloat(), false));
        }
        return new AnalyticsEvent(name, category, eventType, timestamp, attributeSet);
    }

    public static Collection<AnalyticsEvent> newFromJson(JsonArray analyticsEventsJson) {
        ArrayList<AnalyticsEvent> events = new ArrayList<AnalyticsEvent>();
        for (JsonElement e : analyticsEventsJson) {
            events.add(AnalyticsEvent.newFromJson(e.getAsJsonObject()));
        }
        return events;
    }
}

