/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.connectivity;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.connectivity.CatFacade;
import com.newrelic.agent.android.connectivity.CatPayload;
import com.newrelic.agent.android.connectivity.UserActionType;
import java.util.Map;

public class UserActionFacade {
    private static CatFacade catFacade = CatFacade.getInstance();
    private static UserActionFacade instance = new UserActionFacade();

    public static UserActionFacade getInstance() {
        return instance;
    }

    public static void recordUserAction(UserActionType type) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            CatPayload payload = catFacade.startTrip();
            Map<String, Object> attributes = payload.asMapForUserAction();
            attributes.put("actionType", type.toString());
            AnalyticsControllerImpl.getInstance().internalRecordEvent(null, AnalyticsEventCategory.UserAction, "MobileUserAction", attributes);
        }
    }

    static void setCatFacade(CatFacade catFacade) {
        UserActionFacade.catFacade = catFacade;
    }
}

