/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.instrumentation.HttpURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.HttpsURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.okhttp3.CallExtension;
import com.newrelic.agent.android.instrumentation.okhttp3.RequestBuilderExtension;
import com.newrelic.agent.android.instrumentation.okhttp3.ResponseBuilderExtension;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.http.StreamAllocation;

public class OkHttp3Instrumentation {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    private OkHttp3Instrumentation() {
    }

    @ReplaceCallSite
    public static Request build(Request.Builder builder) {
        return new RequestBuilderExtension(builder).build();
    }

    @ReplaceCallSite
    public static Call newCall(OkHttpClient client, Request request) {
        TransactionState transactionState = new TransactionState();
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            transactionState.setCatPayload(Agent.getCatFacade().createCatPayload());
            try {
                Request instrumentedRequest = request.newBuilder().header("X-NewRelic-Trace", transactionState.getCatPayload().asBase64Json()).build();
                return new CallExtension(client, instrumentedRequest, client.newCall(instrumentedRequest), transactionState);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return new CallExtension(client, request, client.newCall(request), transactionState);
    }

    @ReplaceCallSite
    public static Response.Builder body(Response.Builder builder, ResponseBody body) {
        return new ResponseBuilderExtension(builder).body(body);
    }

    @ReplaceCallSite
    public static Response.Builder newBuilder(Response.Builder builder) {
        return new ResponseBuilderExtension(builder);
    }

    @ReplaceCallSite(isStatic=false, scope="okhttp3.OkUrlFactory")
    public static HttpURLConnection open(OkUrlFactory factory, URL url) {
        HttpURLConnection conn = factory.open(url);
        String protocol = url.getProtocol();
        if (protocol.equals("http")) {
            return new HttpURLConnectionExtension(conn);
        }
        if (protocol.equals("https") && conn instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)conn);
        }
        return new HttpURLConnectionExtension(conn);
    }

    private static void logReflectionError(String signature) {
        String crlf = System.getProperty("line.separator");
        log.error("Unable to resolve method \"" + signature + "\"." + crlf + "This is usually due to building the app with unsupported OkHttp versions." + crlf + "Check your build configuration for compatibility.");
    }

    public static class OkHttp32 {
        @ReplaceCallSite
        public static void callEnqueue(Internal internal, Call call, Callback responseCallback, boolean forWebSocket) {
            try {
                Method callEnqueue;
                if (call instanceof CallExtension) {
                    call = ((CallExtension)call).getImpl();
                }
                if ((callEnqueue = Internal.class.getMethod("callEnqueue", Call.class, Callback.class, Boolean.TYPE)) != null) {
                    callEnqueue.invoke((Object)internal, call, responseCallback, forWebSocket);
                } else {
                    OkHttp3Instrumentation.logReflectionError("callEnqueue(Lokhttp3/Call;Lokhttp3/Callback;Z)V");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }

        @ReplaceCallSite
        public static StreamAllocation callEngineGetStreamAllocation(Internal internal, Call call) {
            StreamAllocation streamAllocation = null;
            try {
                Method callEngineGetStreamAllocation;
                if (call instanceof CallExtension) {
                    call = ((CallExtension)call).getImpl();
                }
                if ((callEngineGetStreamAllocation = Internal.class.getMethod("callEngineGetStreamAllocation", Call.class)) != null) {
                    streamAllocation = (StreamAllocation)callEngineGetStreamAllocation.invoke((Object)internal, call);
                } else {
                    OkHttp3Instrumentation.logReflectionError("callEngineGetStreamAllocation(Lokhttp3/Call;)Lokhttp3/internal/http/StreamAllocation;");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            return streamAllocation;
        }
    }

    public static class OkHttp35 {
        @ReplaceCallSite
        public static Call newWebSocketCall(Internal internal, OkHttpClient client, Request request) {
            CallExtension call = null;
            try {
                Method newWebSocketCall = Internal.class.getMethod("newWebSocketCall", OkHttpClient.class, Request.class);
                if (newWebSocketCall != null) {
                    TransactionState transactionState = new TransactionState();
                    if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
                        transactionState.setCatPayload(Agent.getCatFacade().createCatPayload());
                        Request instrumentedRequest = request.newBuilder().header("X-NewRelic-Trace", transactionState.getCatPayload().asBase64Json()).build();
                        Call impl = (Call)newWebSocketCall.invoke((Object)internal, client, instrumentedRequest);
                        call = new CallExtension(client, instrumentedRequest, impl, transactionState);
                    } else {
                        Call impl = (Call)newWebSocketCall.invoke((Object)internal, client, request);
                        call = new CallExtension(client, request, impl, transactionState);
                    }
                } else {
                    OkHttp3Instrumentation.logReflectionError("newWebSocketCall(Lokhttp3/OkHttpClient;Lokhttp3/Request;)Lokhttp3/Call;");
                }
            }
            catch (Exception e) {
                log.error("OkHttp3Instrumentation: " + e.getMessage());
            }
            return call;
        }
    }

    public static class OkHttp34 {
        @ReplaceCallSite
        public static void setCallWebSocket(Internal internal, Call call) {
            try {
                Method setCallWebSocket;
                if (call instanceof CallExtension) {
                    call = ((CallExtension)call).getImpl();
                }
                if ((setCallWebSocket = Internal.class.getMethod("setCallWebSocket", Call.class)) != null) {
                    setCallWebSocket.invoke((Object)internal, call);
                } else {
                    OkHttp3Instrumentation.logReflectionError("setCallWebSocket(Lokhttp3/Call;)V");
                }
            }
            catch (Exception e) {
                log.error("OkHttp3Instrumentation: " + e.getMessage());
            }
        }

        @ReplaceCallSite
        public static okhttp3.internal.connection.StreamAllocation callEngineGetStreamAllocation(Internal internal, Call call) {
            okhttp3.internal.connection.StreamAllocation streamAllocation = null;
            try {
                Method callEngineGetStreamAllocation;
                if (call instanceof CallExtension) {
                    call = ((CallExtension)call).getImpl();
                }
                if ((callEngineGetStreamAllocation = Internal.class.getMethod("callEngineGetStreamAllocation", Call.class)) != null) {
                    streamAllocation = (okhttp3.internal.connection.StreamAllocation)callEngineGetStreamAllocation.invoke((Object)internal, call);
                } else {
                    OkHttp3Instrumentation.logReflectionError("callEngineGetStreamAllocation(Lokhttp3/Call;)Lokhttp3/internal/connection/StreamAllocation;");
                }
            }
            catch (Exception e) {
                log.error("OkHttp3Instrumentation: " + e.getMessage());
            }
            return streamAllocation;
        }
    }
}

