/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.retrofit;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.connectivity.CatFacade;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.util.List;
import java.util.TreeMap;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;

public class RetrofitTransactionStateUtil
extends TransactionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final CatFacade catFacade = Agent.getCatFacade();
    private static final String CONTENT_TYPE_HEADER = "Content-Type";

    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        transactionState.setUrl(request.getUrl());
        transactionState.setHttpMethod(request.getMethod());
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
        transactionState.setWanType(Agent.getActiveNetworkWanType());
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            transactionState.setCatPayload(catFacade.createCatPayload());
        }
    }

    public static void inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = RetrofitTransactionStateUtil.getAppDataHeader(response.getHeaders(), "X-NewRelic-App-Data");
        if (appData != null && !"".equals(appData)) {
            transactionState.setAppData(appData);
        }
        int statusCode = response.getStatus();
        transactionState.setStatusCode(statusCode);
        long contentLength = response.getBody().length();
        if (contentLength >= 0L) {
            transactionState.setBytesReceived(contentLength);
        }
        RetrofitTransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    private static String getAppDataHeader(List<Header> headers, String headerName) {
        if (headers != null) {
            for (Header header : headers) {
                if (header.getName() == null || !header.getName().equalsIgnoreCase(headerName)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    protected static void addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData == null) {
            return;
        }
        if (transactionState.isErrorOrFailure()) {
            String contentTypeHeader = RetrofitTransactionStateUtil.getAppDataHeader(response.getHeaders(), CONTENT_TYPE_HEADER);
            TreeMap<String, String> params = new TreeMap<String, String>();
            if (contentTypeHeader != null && contentTypeHeader.length() > 0 && !"".equals(contentTypeHeader)) {
                params.put("content_type", contentTypeHeader);
            }
            params.put("content_length", transactionState.getBytesReceived() + "");
            transactionData.setParams(params);
            Measurements.addHttpError(transactionData);
        }
        HttpTransactionMeasurement httpTransactionMeasurement = new HttpTransactionMeasurement(transactionData);
        TaskQueue.queue(httpTransactionMeasurement);
    }
}

