/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.payload;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.agentdata.AgentDataReporter;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadReaper;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PayloadController
implements HarvestLifecycleAware {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    public static final long PAYLOAD_COLLECTOR_TIMEOUT = 3000L;
    public static final long PAYLOAD_REQUEUE_PERIOD_MS = 120000L;
    protected static Lock payloadQueueLock = new ReentrantLock(false);
    protected static AtomicReference<PayloadController> instance = new AtomicReference<Object>(null);
    protected static ThrottledScheduledThreadPoolExecutor queueExecutor = null;
    protected static ScheduledFuture<?> requeueFuture = null;
    protected static ConcurrentLinkedQueue<PayloadReaper> payloadReaperQueue = null;
    protected static ConcurrentLinkedQueue<PayloadReaper> payloadReaperRetryQueue = null;
    protected static Map<String, Future> reapersInFlight = null;
    protected static boolean opportunisticUploads = false;
    protected static final Runnable dequeueRunnable = new Runnable(){

        @Override
        public void run() {
            if (PayloadController.isInitialized()) {
                instance.get().dequeuePayloadSenders();
            }
        }
    };
    protected static final Runnable requeueRunnable = new Runnable(){

        @Override
        public void run() {
            if (PayloadController.isInitialized()) {
                instance.get().requeuePayloadSenders();
            }
        }
    };
    private final AgentConfiguration agentConfiguration;

    public static PayloadController initialize(AgentConfiguration agentConfiguration) {
        if (instance.compareAndSet(null, new PayloadController(agentConfiguration))) {
            payloadReaperQueue = new ConcurrentLinkedQueue();
            payloadReaperRetryQueue = new ConcurrentLinkedQueue();
            queueExecutor = new ThrottledScheduledThreadPoolExecutor(agentConfiguration.getIOThreadSize(), new NamedThreadFactory("NR-PayloadWorker"));
            requeueFuture = queueExecutor.scheduleAtFixedRate(requeueRunnable, 120000L, 120000L, TimeUnit.MILLISECONDS);
            reapersInFlight = new ConcurrentHashMap<String, Future>();
            opportunisticUploads = false;
            CrashReporter crashReporter = CrashReporter.initialize(agentConfiguration);
            if (crashReporter != null) {
                crashReporter.start();
            } else {
                log.warning("PayloadController.initialize: No crash reporter - crash reporting will be disabled");
            }
            AgentDataReporter agentDataReporter = AgentDataReporter.initialize(agentConfiguration);
            if (agentDataReporter != null) {
                agentDataReporter.start();
            } else {
                log.warning("PayloadController.initialize: No payload reporter - payload reporting will be disabled");
            }
            Harvest.addHarvestListener(instance.get());
        }
        return instance.get();
    }

    public static void shutdown() {
        if (PayloadController.isInitialized()) {
            try {
                Harvest.removeHarvestListener(instance.get());
                if (requeueFuture != null) {
                    requeueFuture.cancel(true);
                    requeueFuture = null;
                }
                queueExecutor.shutdown();
                try {
                    CrashReporter.shutdown();
                    AgentDataReporter.shutdown();
                    if (!queueExecutor.awaitTermination(3000L, TimeUnit.MILLISECONDS)) {
                        log.warning("PayloadController.shutdown: upload thread(s) timed-out before handler");
                        queueExecutor.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                instance.set(null);
            }
        }
    }

    public static Future submitPayload(PayloadSender payloadSender) {
        return PayloadController.submitPayload(payloadSender, null);
    }

    public static Future submitPayload(PayloadSender payloadSender, PayloadSender.CompletionHandler completionHandler) {
        Future<PayloadSender> future = null;
        TicToc timer = new TicToc();
        if (PayloadController.isInitialized()) {
            timer.tic();
            PayloadReaper payloadReaper = new PayloadReaper(payloadSender, completionHandler){

                @Override
                public PayloadSender call() throws Exception {
                    PayloadSender sender = super.call();
                    if (sender != null && !sender.isSuccessfulResponse() && sender.shouldRetry()) {
                        payloadReaperRetryQueue.offer(this);
                    }
                    reapersInFlight.remove(this.getUuid());
                    return sender;
                }
            };
            payloadReaperQueue.remove(payloadReaper);
            payloadReaperRetryQueue.remove(payloadReaper);
            future = reapersInFlight.get(payloadReaper.getUuid());
            if (future != null) {
                log.warning("PayloadController.submitPayload: [" + payloadReaper.getUuid() + "] is already in progress.");
            } else {
                if (payloadSender.shouldUploadOpportunistically()) {
                    future = queueExecutor.submit(payloadReaper);
                    reapersInFlight.put(payloadReaper.getUuid(), future);
                } else {
                    payloadReaperQueue.offer(payloadReaper);
                }
                log.debug("PayloadController.submitPayload: " + String.valueOf(timer.toc()) + "ms. waiting to submit payload [" + payloadReaper.getUuid() + "].");
            }
        }
        return future;
    }

    protected static Future submitPayload(PayloadReaper payloadReaper) {
        Future<PayloadSender> future = null;
        if (PayloadController.isInitialized()) {
            payloadReaperQueue.remove(payloadReaper);
            payloadReaperRetryQueue.remove(payloadReaper);
            future = reapersInFlight.get(payloadReaper.getUuid());
            if (future != null) {
                log.warning("PayloadController.submitPayload: [" + payloadReaper.getUuid() + "] is already in progress.");
            } else {
                future = queueExecutor.submit(payloadReaper);
                reapersInFlight.put(payloadReaper.getUuid(), future);
            }
        }
        return future;
    }

    public static boolean shouldUploadOpportunistically() {
        return opportunisticUploads && Agent.hasReachableNetworkConnection(null);
    }

    public static Future submitCallable(Callable callable) {
        return queueExecutor.submit(callable);
    }

    public static boolean isInitialized() {
        return instance.get() != null;
    }

    protected PayloadController(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
    }

    private final void dequeuePayloadSenders() {
        block8: {
            if (payloadQueueLock.tryLock()) {
                block5: while (true) {
                    while (!payloadReaperQueue.isEmpty()) {
                        PayloadReaper payloadReaper = payloadReaperQueue.poll();
                        if (payloadReaper == null) continue;
                        try {
                            PayloadController.submitPayload(payloadReaper);
                            continue block5;
                        }
                        catch (Exception e) {
                            log.error("PayloadController.dequeuePayloadSenders(): " + e);
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    payloadQueueLock.unlock();
                }
            }
        }
    }

    private void requeuePayloadSenders() {
        if (payloadQueueLock.tryLock()) {
            try {
                while (!payloadReaperRetryQueue.isEmpty()) {
                    PayloadReaper payloadReaper = payloadReaperRetryQueue.poll();
                    if (payloadReaper == null) continue;
                    if (!payloadReaper.sender.getPayload().isStale(this.agentConfiguration.getPayloadTTL())) {
                        PayloadController.submitPayload(payloadReaper);
                        continue;
                    }
                    log.warning("PayloadController.requeuePayloadSenders: Will not re-queue stale payload.");
                }
            }
            finally {
                payloadQueueLock.unlock();
            }
        }
    }

    protected boolean uploadOpportunistically() {
        return opportunisticUploads;
    }

    @Override
    public void onHarvestComplete() {
    }

    @Override
    public void onHarvestStart() {
    }

    @Override
    public void onHarvestStop() {
    }

    @Override
    public void onHarvestBefore() {
    }

    @Override
    public void onHarvest() {
        queueExecutor.submit(dequeueRunnable);
    }

    @Override
    public void onHarvestFinalize() {
    }

    @Override
    public void onHarvestError() {
    }

    @Override
    public void onHarvestSendFailed() {
    }

    @Override
    public void onHarvestConnected() {
    }

    @Override
    public void onHarvestDisconnected() {
    }

    @Override
    public void onHarvestDisabled() {
    }

    public static boolean payloadInFlight(Payload payload) {
        return reapersInFlight.containsKey(payload.getUuid());
    }

    protected static class ThrottledScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        protected static final int THROTTLE_LIMIT = 16;
        protected static final int THROTTLE_SLEEP = 50;

        public ThrottledScheduledThreadPoolExecutor(int i, ThreadFactory threadFactory) {
            super(i, threadFactory);
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            if (this.getQueue().size() >= 16) {
                StatsEngine.get().inc("Supportability/AgentHealth/Hex/UploadThrottled");
            }
            return super.submit(callable);
        }
    }
}

