/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.agentdata.builder;

import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.com.google.flatbuffers.Table;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.mobile.fbs.AgentData;
import com.newrelic.mobile.fbs.AgentDataBundle;
import com.newrelic.mobile.fbs.ApplicationInfo;
import com.newrelic.mobile.fbs.BoolSessionAttribute;
import com.newrelic.mobile.fbs.DoubleSessionAttribute;
import com.newrelic.mobile.fbs.LongSessionAttribute;
import com.newrelic.mobile.fbs.StringSessionAttribute;
import com.newrelic.mobile.fbs.hex.Frame;
import com.newrelic.mobile.fbs.hex.HandledException;
import com.newrelic.mobile.fbs.hex.Thread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentDataBuilder {
    protected static void computeIfAbsent(String s, Map<String, Integer> map, FlatBufferBuilder flat) {
        if (null != s && !map.containsValue(s)) {
            int offset = flat.createString(s);
            map.put(s, offset);
        }
    }

    public static FlatBufferBuilder startAndFinishAgentData(Map<String, Object> attributesMap, Set<Map<String, Object>> agentData) {
        HashMap<String, Integer> stringIndexMap = new HashMap<String, Integer>();
        FlatBufferBuilder flat = new FlatBufferBuilder();
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            String string = entry.getKey();
            Iterator val = entry.getValue();
            AgentDataBuilder.computeIfAbsent(string, stringIndexMap, flat);
            if (!(val instanceof String)) continue;
            String s = (String)((Object)val);
            AgentDataBuilder.computeIfAbsent(s, stringIndexMap, flat);
        }
        List thread = null;
        for (Map<String, Object> map : agentData) {
            AgentDataBuilder.computeIfAbsent((String)map.get("name"), stringIndexMap, flat);
            AgentDataBuilder.computeIfAbsent((String)map.get("message"), stringIndexMap, flat);
            AgentDataBuilder.computeIfAbsent((String)map.get("cause"), stringIndexMap, flat);
            thread = (List)map.get("thread");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (thread != null) {
            for (Map frame : thread) {
                HashMap<String, Integer> frameValStringIndexMap = new HashMap<String, Integer>();
                frameValStringIndexMap.put("fileName", flat.createString(""));
                for (Map.Entry frameElement : frame.entrySet()) {
                    String key = (String)frameElement.getKey();
                    Object val = frameElement.getValue();
                    if (!(val instanceof String)) continue;
                    int offset = flat.createString((String)val);
                    frameValStringIndexMap.put(key, offset);
                }
                Frame.startFrame(flat);
                if (frameValStringIndexMap.get("className") != null) {
                    Frame.addClassName(flat, (Integer)frameValStringIndexMap.get("className"));
                }
                if (frameValStringIndexMap.get("methodName") != null) {
                    Frame.addMethodName(flat, (Integer)frameValStringIndexMap.get("methodName"));
                }
                if (frameValStringIndexMap.get("fileName") != null) {
                    Frame.addFileName(flat, (Integer)frameValStringIndexMap.get("fileName"));
                }
                if (frame.get("lineNumber") != null) {
                    Frame.addLineNumber(flat, ((Integer)frame.get("lineNumber")).intValue());
                }
                int frameOffset = Frame.endFrame(flat);
                arrayList.add(frameOffset);
            }
        }
        int framesOffset = Thread.createFramesVector(flat, AgentDataBuilder.toArray(arrayList));
        int threadOffset = Thread.createThread(flat, framesOffset);
        arrayList2.add(threadOffset);
        int threadVectorOffset = HandledException.createThreadsVector(flat, AgentDataBuilder.toArray(arrayList2));
        HashSet<Integer> stringSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> doubleSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> longSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> boolSessionAttributes = new HashSet<Integer>();
        for (Map.Entry<String, Object> attribute : attributesMap.entrySet()) {
            Object n;
            String key = attribute.getKey();
            int keyIndex = (Integer)stringIndexMap.get(key);
            Object val = attribute.getValue();
            if (val instanceof String) {
                stringSessionAttributes.add(StringSessionAttribute.createStringSessionAttribute(flat, keyIndex, (Integer)stringIndexMap.get(val)));
                continue;
            }
            if (val instanceof Double || val instanceof Float) {
                n = (Number)val;
                doubleSessionAttributes.add(DoubleSessionAttribute.createDoubleSessionAttribute(flat, keyIndex, ((Number)n).doubleValue()));
                continue;
            }
            if (val instanceof Number) {
                n = (Number)val;
                longSessionAttributes.add(LongSessionAttribute.createLongSessionAttribute(flat, keyIndex, ((Number)n).longValue()));
                continue;
            }
            if (!(val instanceof Boolean)) continue;
            boolSessionAttributes.add(BoolSessionAttribute.createBoolSessionAttribute(flat, keyIndex, (Boolean)val));
        }
        int stringSessionAttributesVector = -1;
        if (!stringSessionAttributes.isEmpty()) {
            stringSessionAttributesVector = AgentData.createStringAttributesVector(flat, AgentDataBuilder.toArray(stringSessionAttributes));
        }
        int doubleSessionAttributesVector = -1;
        if (!doubleSessionAttributes.isEmpty()) {
            doubleSessionAttributesVector = AgentData.createDoubleAttributesVector(flat, AgentDataBuilder.toArray(doubleSessionAttributes));
        }
        int longSessionAttributesVector = -1;
        if (!longSessionAttributes.isEmpty()) {
            longSessionAttributesVector = AgentData.createLongAttributesVector(flat, AgentDataBuilder.toArray(longSessionAttributes));
        }
        int booleanSessionAttributesVector = -1;
        if (!boolSessionAttributes.isEmpty()) {
            booleanSessionAttributesVector = AgentData.createBoolAttributesVector(flat, AgentDataBuilder.toArray(boolSessionAttributes));
        }
        HashSet<Integer> handledExceptionOffsets = new HashSet<Integer>();
        if (!agentData.isEmpty()) {
            for (Map map : agentData) {
                int nameOffset = AgentDataBuilder.stringIndexMapOffset(stringIndexMap, map.get("name"));
                int messageOffset = AgentDataBuilder.stringIndexMapOffset(stringIndexMap, map.get("message"));
                int causeOffset = AgentDataBuilder.stringIndexMapOffset(stringIndexMap, map.get("cause"));
                long timeStampMs = (Long)(map.containsKey("timestampMs") ? map.get("timestampMs") : Long.valueOf(System.currentTimeMillis()));
                long appUuidHigh = 0L;
                long appUuidLow = 0L;
                try {
                    appUuidHigh = (Long)map.get("appUuidHigh");
                    appUuidLow = (Long)map.get("appUuidLow");
                }
                catch (ClassCastException e) {
                    appUuidHigh = 0L;
                    appUuidLow = 0L;
                }
                HandledException.startHandledException(flat);
                HandledException.addAppUuidHigh(flat, appUuidHigh);
                HandledException.addAppUuidLow(flat, appUuidLow);
                if (-1L != timeStampMs) {
                    HandledException.addTimestampMs(flat, timeStampMs);
                }
                if (-1 != nameOffset) {
                    HandledException.addName(flat, nameOffset);
                }
                if (-1 != messageOffset) {
                    HandledException.addMessage(flat, messageOffset);
                }
                if (-1 != causeOffset) {
                    HandledException.addCause(flat, causeOffset);
                }
                HandledException.addThreads(flat, threadVectorOffset);
                int handledExceptionOffset = HandledException.endHandledException(flat);
                handledExceptionOffsets.add(handledExceptionOffset);
            }
        }
        int handledExceptionVector = -1;
        if (!handledExceptionOffsets.isEmpty()) {
            handledExceptionVector = AgentData.createHandledExceptionsVector(flat, AgentDataBuilder.toArray(handledExceptionOffsets));
        }
        ApplicationInfo.startApplicationInfo(flat);
        ApplicationInfo.addPlatform(flat, 0);
        int n = ApplicationInfo.endApplicationInfo(flat);
        AgentData.startAgentData(flat);
        if (stringSessionAttributesVector != -1) {
            AgentData.addStringAttributes(flat, stringSessionAttributesVector);
        }
        if (doubleSessionAttributesVector != -1) {
            AgentData.addDoubleAttributes(flat, doubleSessionAttributesVector);
        }
        if (longSessionAttributesVector != -1) {
            AgentData.addLongAttributes(flat, longSessionAttributesVector);
        }
        if (booleanSessionAttributesVector != -1) {
            AgentData.addBoolAttributes(flat, booleanSessionAttributesVector);
        }
        if (handledExceptionVector != -1) {
            AgentData.addHandledExceptions(flat, handledExceptionVector);
        }
        AgentData.addApplicationInfo(flat, n);
        HashSet<Integer> agentDataOffsets = new HashSet<Integer>();
        int agentDataOffset = AgentData.endAgentData(flat);
        agentDataOffsets.add(agentDataOffset);
        int agentDataVector = AgentDataBundle.createAgentDataVector(flat, AgentDataBuilder.toArray(agentDataOffsets));
        AgentDataBundle.startAgentDataBundle(flat);
        AgentDataBundle.addAgentData(flat, agentDataVector);
        int agentDataBundleOffset = AgentDataBundle.endAgentDataBundle(flat);
        flat.finish(agentDataBundleOffset);
        return flat;
    }

    private static int stringIndexMapOffset(Map<String, Integer> stringIndexMap, Object hexKey) {
        Integer index;
        Integer offset = -1;
        if (hexKey != null && (index = stringIndexMap.get(hexKey)) != null) {
            offset = index;
        }
        return offset;
    }

    private static int[] toArray(Collection<Integer> c) {
        int[] a = new int[c.size()];
        Iterator<Integer> i = c.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index++] = i.next();
        }
        return a;
    }

    public static String toJsonString(AgentDataBundle agentDataBundle, int index) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().setPrettyPrinting().create();
        AgentData agentData = agentDataBundle.agentData(index);
        return gson.toJson(AgentDataBuilder.attributesMapFromAgentData(agentData));
    }

    public static Map<String, Object> attributesMapFromAgentData(AgentData agentData) {
        Table a;
        int si;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (si = 0; si < agentData.stringAttributesLength(); ++si) {
            a = agentData.stringAttributes(si);
            map.put(((StringSessionAttribute)a).name(), ((StringSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.longAttributesLength(); ++si) {
            a = agentData.longAttributes(si);
            map.put(((LongSessionAttribute)a).name(), ((LongSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.doubleAttributesLength(); ++si) {
            a = agentData.doubleAttributes(si);
            map.put(((DoubleSessionAttribute)a).name(), ((DoubleSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.boolAttributesLength(); ++si) {
            a = agentData.boolAttributes(si);
            map.put(((BoolSessionAttribute)a).name(), ((BoolSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.handledExceptionsLength(); ++si) {
            HandledException hex = agentData.handledExceptions(si);
            map.put("timestampMs", hex.timestampMs());
            map.put("appUuidHigh", hex.appUuidHigh());
            map.put("appUuidLow", hex.appUuidLow());
            map.put("name", hex.name());
            map.put("cause", hex.cause());
            map.put("message", hex.message());
            for (int t = 0; t < hex.threadsLength(); ++t) {
                java.lang.Thread currentThread = java.lang.Thread.currentThread();
                LinkedHashMap<String, Object> threadMap = new LinkedHashMap<String, Object>();
                for (int f = 0; f < hex.threads(t).framesLength(); ++f) {
                    LinkedHashMap<String, Object> frameMap = new LinkedHashMap<String, Object>();
                    frameMap.put("fileName", hex.threads(t).frames(f).fileName());
                    frameMap.put("lineNumber", hex.threads(t).frames(f).lineNumber());
                    frameMap.put("className", hex.threads(t).frames(f).className());
                    frameMap.put("methodName", hex.threads(t).frames(f).methodName());
                    threadMap.put("frame " + f, frameMap);
                }
                threadMap.put("crashed", false);
                threadMap.put("state", currentThread.getState().toString());
                threadMap.put("threadNumber", currentThread.getId());
                threadMap.put("threadId", currentThread.getName());
                threadMap.put("priority", currentThread.getPriority());
                map.put("thread " + t, threadMap);
            }
        }
        return map;
    }
}

