/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.harvest.HttpTransaction;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetworkRequestEvent
extends AnalyticsEvent {
    static AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();

    public NetworkRequestEvent(Set<AnalyticAttribute> attributeSet) {
        super(null, AnalyticsEventCategory.NetworkRequest, "MobileRequest", attributeSet);
    }

    public static NetworkRequestEvent createNetworkEvent(HttpTransaction txn) {
        Set<AnalyticAttribute> attributes = NetworkRequestEvent.createDefaultAttributeSet(txn);
        attributes.add(new AnalyticAttribute("responseTime", txn.getTotalTime()));
        attributes.add(new AnalyticAttribute("statusCode", txn.getStatusCode()));
        attributes.add(new AnalyticAttribute("bytesSent", txn.getBytesSent()));
        attributes.add(new AnalyticAttribute("bytesReceived", txn.getBytesReceived()));
        return new NetworkRequestEvent(attributes);
    }

    static Set<AnalyticAttribute> createDefaultAttributeSet(HttpTransaction txn) {
        double bytesReceived;
        double bytesSent;
        HashSet<AnalyticAttribute> attributes = new HashSet<AnalyticAttribute>();
        try {
            URL url = new URL(txn.getUrl());
            attributes.add(new AnalyticAttribute("requestDomain", url.getHost()));
            attributes.add(new AnalyticAttribute("requestPath", url.getPath()));
        }
        catch (MalformedURLException e) {
            log.error(txn.getUrl() + " is not a valid URL. Unable to set host or path attributes.");
        }
        attributes.add(new AnalyticAttribute("requestUrl", txn.getUrl()));
        attributes.add(new AnalyticAttribute("connectionType", txn.getWanType()));
        attributes.add(new AnalyticAttribute("requestMethod", txn.getHttpMethod()));
        double totalTime = txn.getTotalTime();
        if (totalTime != 0.0) {
            attributes.add(new AnalyticAttribute("responseTime", totalTime));
        }
        if ((bytesSent = (double)txn.getBytesSent()) != 0.0) {
            attributes.add(new AnalyticAttribute("bytesSent", bytesSent));
        }
        if ((bytesReceived = (double)txn.getBytesReceived()) != 0.0) {
            attributes.add(new AnalyticAttribute("bytesReceived", bytesReceived));
        }
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            Map<String, Object> intrinsics = txn.getCatPayload().asMapForRequest();
            for (Map.Entry<String, Object> intrinsic : intrinsics.entrySet()) {
                AnalyticAttribute attribute = analyticsController.createAttribute(intrinsic.getKey(), intrinsic.getValue());
                if (attribute != null) {
                    attributes.add(attribute);
                    continue;
                }
                log.error("Unsupported event attribute type for key [" + intrinsic.getKey() + "]: " + intrinsic.getValue().getClass().getName());
            }
        }
        return attributes;
    }
}

