/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.os.Build;
import android.view.View;
import android.view.ViewStub;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.gestures.GestureReporter;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.ViewListeners;
import java.lang.reflect.Field;

public class ViewInstrumentation {
    static final String ON_TOUCH_LISTENER_FIELD = "onTouchListener";
    static final String ON_CLICK_LISTENER_FIELD = "mOnClickListener";
    static final String ON_LONG_CLICK_LISTENER_FIELD = "mOnLongClickListener";
    private static final String VIEW_CLASS_NAME = "android.view.View";
    private static final String LISTENER_INFO_FIELD_NAME = "mListenerInfo";
    private static final String ANDROID_VIEW_LISTENER_INFO = "android.view.View$ListenerInfo";

    ViewInstrumentation() {
    }

    @ReplaceCallSite
    public static final View inflate(ViewStub viewStub) {
        View view = viewStub.inflate();
        GestureReporter gestureReporter = GestureReporter.getGestureReporter();
        if (gestureReporter != null) {
            gestureReporter.addView(view);
        }
        return view;
    }

    @ReplaceCallSite
    public static final void setOnTouchListener(View view, View.OnTouchListener listener) {
        try {
            if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
                View.OnTouchListener current = (View.OnTouchListener)ViewInstrumentation.getViewListener(view, ON_TOUCH_LISTENER_FIELD);
                if (current == null) {
                    ViewListeners.OnTouchListenerDelegate delegate = new ViewListeners.OnTouchListenerDelegate(view, listener);
                    view.setOnTouchListener((View.OnTouchListener)delegate);
                } else if (current instanceof ViewListeners.OnTouchListenerDelegate) {
                    ViewListeners.OnTouchListenerDelegate delegate = (ViewListeners.OnTouchListenerDelegate)current;
                    delegate.addListener(listener);
                } else {
                    ViewListeners.OnTouchListenerDelegate delegate = new ViewListeners.OnTouchListenerDelegate(view, current);
                    delegate.addListener(listener);
                    view.setOnTouchListener((View.OnTouchListener)delegate);
                }
            } else {
                view.setOnTouchListener(listener);
            }
        }
        catch (NoSuchFieldError e) {
            view.setOnTouchListener(listener);
        }
    }

    @ReplaceCallSite
    public static final void setOnClickListener(View view, View.OnClickListener listener) {
        try {
            if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
                View.OnClickListener current = (View.OnClickListener)ViewInstrumentation.getViewListener(view, ON_CLICK_LISTENER_FIELD);
                if (current == null) {
                    ViewListeners.OnClickListenerDelegate delegate = new ViewListeners.OnClickListenerDelegate(view, listener);
                    view.setOnClickListener((View.OnClickListener)delegate);
                } else if (current instanceof ViewListeners.OnClickListenerDelegate) {
                    ViewListeners.OnClickListenerDelegate delegate = (ViewListeners.OnClickListenerDelegate)current;
                    delegate.addListener(listener);
                } else {
                    ViewListeners.OnClickListenerDelegate delegate = new ViewListeners.OnClickListenerDelegate(view, current);
                    delegate.addListener(listener);
                    view.setOnClickListener((View.OnClickListener)delegate);
                }
            } else {
                view.setOnClickListener(listener);
            }
        }
        catch (Exception e) {
            view.setOnClickListener(listener);
        }
    }

    @ReplaceCallSite
    public static final void setOnLongClickListener(View view, View.OnLongClickListener listener) {
        try {
            if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
                View.OnLongClickListener current = (View.OnLongClickListener)ViewInstrumentation.getViewListener(view, ON_LONG_CLICK_LISTENER_FIELD);
                if (current == null) {
                    ViewListeners.OnLongClickListenerDelegate delegate = new ViewListeners.OnLongClickListenerDelegate(view, listener);
                    view.setOnLongClickListener((View.OnLongClickListener)delegate);
                } else if (current instanceof ViewListeners.OnLongClickListenerDelegate) {
                    ViewListeners.OnLongClickListenerDelegate delegate = (ViewListeners.OnLongClickListenerDelegate)current;
                    delegate.addListener(listener);
                } else {
                    ViewListeners.OnLongClickListenerDelegate delegate = new ViewListeners.OnLongClickListenerDelegate(view, current);
                    delegate.addListener(listener);
                    view.setOnLongClickListener((View.OnLongClickListener)delegate);
                }
            } else {
                view.setOnLongClickListener(listener);
            }
        }
        catch (NoSuchFieldError e) {
            view.setOnLongClickListener(listener);
        }
    }

    static Object getViewListener(View view, String listenerFieldname) {
        Object returnedField = null;
        try {
            if (Build.VERSION.SDK_INT < 14) {
                Field field = Class.forName(VIEW_CLASS_NAME).getDeclaredField(listenerFieldname);
                returnedField = field.get(view);
            } else {
                Field listenerInfoField = Class.forName(VIEW_CLASS_NAME).getDeclaredField(LISTENER_INFO_FIELD_NAME);
                if (listenerInfoField != null) {
                    Field listenerField;
                    listenerInfoField.setAccessible(true);
                    Object object = listenerInfoField.get(view);
                    if (object != null && (listenerField = Class.forName(ANDROID_VIEW_LISTENER_INFO).getDeclaredField(listenerFieldname)) != null) {
                        listenerField.setAccessible(true);
                        returnedField = listenerField.get(object);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnedField;
    }
}

