/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.gestures;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.v4.view.GestureDetectorCompat;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.TextView;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.connectivity.UserActionFacade;
import com.newrelic.agent.android.connectivity.UserActionType;
import com.newrelic.agent.android.gestures.GestureObserver;
import com.newrelic.agent.android.instrumentation.ViewInstrumentation;
import com.newrelic.agent.android.instrumentation.ViewListeners;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;

@TargetApi(value=11)
public class GestureReporter
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    final GestureDetectorCompat detector;
    final HashMap<Integer, View> controlCache = new HashMap();
    final ExecutorService executor = Executors.newSingleThreadExecutor();
    private String gestureId;
    private static Set<Class> supportedClasses = new HashSet<Class>(Arrays.asList(TextView.class, ImageView.class, ActionBar.class, AdapterView.class, ViewStub.class));
    private static final Map<Integer, GestureReporter> gestureReporterMap = new HashMap<Integer, GestureReporter>();
    private static final AtomicReference<GestureReporter> currentGestureReporter = new AtomicReference<Object>(null);

    public GestureReporter(Activity activity, View rootView) {
        this.detector = new GestureDetectorCompat((Context)activity, (GestureDetector.OnGestureListener)this);
        this.gestureId = this.generateGestureId(rootView);
        this.addView(rootView);
        log.info("[Gesture] Attached to activity [" + activity.getLocalClassName() + "]");
    }

    public void shutdown() {
        try {
            this.executor.shutdown();
            this.controlCache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<View> addView(View view) {
        Set<View> childViews = GestureReporter.gatherChildViews(view);
        this.attachChildTouchListeners(childViews);
        ViewInstrumentation.setOnTouchListener(view, this);
        log.debug("[Gesture] Attached to view [" + view.toString() + "]");
        return childViews;
    }

    public boolean onDown(MotionEvent e) {
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.detector.onTouchEvent(event);
        return false;
    }

    public boolean onFling(final MotionEvent event1, final MotionEvent event2, final float velocityX, final float velocityY) {
        this.bg(new Runnable(){

            @Override
            public void run() {
                log.audit("[Gesture] onFling: MotionEvent1[" + event1.toString() + "] MotionEvent2[" + event2.toString() + "] velX[" + velocityX + "] velY[" + velocityY + "]");
                Map<String, Object> attributes = GestureReporter.this.createGestureMotionEventAttributes(event1);
                UserActionFacade.getInstance().recordUserAction(UserActionType.Swipe, attributes);
            }
        });
        return false;
    }

    public boolean onSingleTapConfirmed(final MotionEvent event) {
        this.bg(new Runnable(){

            @Override
            public void run() {
                log.audit("[Gesture] onSingleTapConfirmed: MotionEvent[" + event.toString() + "]");
                Map<String, Object> attributes = GestureReporter.this.createGestureMotionEventAttributes(event);
                UserActionFacade.getInstance().recordUserAction(UserActionType.Tap, attributes);
            }
        });
        return false;
    }

    public boolean onDoubleTap(final MotionEvent event) {
        this.bg(new Runnable(){

            @Override
            public void run() {
                log.audit("[Gesture] onDoubleTap: MotionEvent[" + event.toString() + "]");
                Map<String, Object> attributes = GestureReporter.this.createGestureMotionEventAttributes(event);
                UserActionFacade.getInstance().recordUserAction(UserActionType.DoubleTap, attributes);
            }
        });
        return false;
    }

    protected Map<String, Object> createGestureMotionEventAttributes(MotionEvent event) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("touchCoordinates", String.format("{%d,%d}", (int)event.getRawX(), (int)event.getRawY()));
        View view = this.findViewByMotionEvent(event);
        if (view != null) {
            attributes.putAll(this.createGestureViewAttributes(view));
        }
        return attributes;
    }

    protected Map<String, Object> createGestureViewAttributes(View view) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        int orientation = Agent.getImpl().getEnvironmentInformation().getOrientation();
        attributes.put("orientation", orientation == 1 ? "Portrait" : "Landscape");
        if (view != null) {
            ViewListeners.ListenerElement element;
            Rect rect = new Rect();
            this.gestureId = this.generateGestureId(view);
            view.getGlobalVisibleRect(rect);
            attributes.put("controlId", this.gestureId);
            attributes.put("controlClass", view.getClass().getName());
            attributes.put("controlRect", String.format(Locale.getDefault(), "{{%d,%d},{%d,%d}}", rect.left, rect.top, rect.left + rect.width(), rect.top + rect.height()));
            if (view.getContentDescription() != null) {
                attributes.put("contentDescription", view.getContentDescription());
            }
            if ((element = ViewListeners.getListenerElement(view.hashCode())) != null) {
                attributes.putAll(this.createGestureControlAttributes(element));
            }
            if (GestureObserver.isSubClassOf(view, TextView.class)) {
                try {
                    TextView textView = (TextView)view;
                    String label = textView.getText().toString();
                    if (!TextUtils.isEmpty((CharSequence)label)) {
                        attributes.put("label", label);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return attributes;
    }

    protected Map<String, Object> createGestureControlAttributes(ViewListeners.ListenerElement element) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (element != null) {
            attributes.put("targetObject", element.targetObject);
            attributes.put("methodExecuted", element.methodExecuted);
        }
        return attributes;
    }

    protected boolean shouldTrackControl(View view) {
        try {
            for (Class clazz : supportedClasses) {
                if (!GestureObserver.isSubClassOf(view, clazz)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void attachChildTouchListeners(Set<View> childViews) {
        for (View childView : childViews) {
            if (!this.shouldTrackControl(childView)) continue;
            this.controlCache.put(childView.hashCode(), childView);
            ViewInstrumentation.setOnTouchListener(childView, this);
            log.debug("[Gesture] Will monitor touch events on view [" + childView.toString() + "]");
        }
    }

    protected static Set<View> gatherChildViews(View v) {
        HashSet<View> childViews = new HashSet<View>();
        if (!GestureObserver.isSubClassOf(v, ViewGroup.class)) {
            childViews.add(v);
            return childViews;
        }
        ViewGroup vg = (ViewGroup)v;
        int childCnt = Math.min(64, vg.getChildCount());
        if (childCnt == 0) {
            childViews.add(v);
        } else {
            for (int i = 0; i < childCnt; ++i) {
                View child = vg.getChildAt(i);
                childViews.addAll(GestureReporter.gatherChildViews(child));
            }
        }
        return childViews;
    }

    private boolean resourceHasPackage(int resid) {
        return resid >>> 24 != 0;
    }

    protected String generateGestureId(View view) {
        String viewId = Integer.valueOf(view.getId()).toString();
        int id = view.getId();
        if (id != -1) {
            StringBuilder out = new StringBuilder(1024);
            out.append(view.getClass().getName());
            out.append('{');
            Resources r = view.getResources();
            if (this.resourceHasPackage(id) && r != null) {
                try {
                    String pkgname;
                    switch (id & 0xFF000000) {
                        case 0x7F000000: {
                            pkgname = "app";
                            break;
                        }
                        case 0x1000000: {
                            pkgname = "android";
                            break;
                        }
                        default: {
                            pkgname = r.getResourcePackageName(id);
                        }
                    }
                    String typename = r.getResourceTypeName(id);
                    String entryname = r.getResourceEntryName(id);
                    out.append(pkgname);
                    out.append(":");
                    out.append(typename);
                    out.append("/");
                    out.append(entryname);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            out.append("}");
            viewId = out.toString();
        } else {
            viewId = UUID.randomUUID().toString();
        }
        return viewId;
    }

    protected View findViewByMotionEvent(MotionEvent event) {
        View targetView = null;
        Rect rect = new Rect();
        int rawX = (int)event.getRawX();
        int rawY = (int)event.getRawY();
        for (View view : this.controlCache.values()) {
            view.getGlobalVisibleRect(rect);
            if (!rect.contains(rawX, rawY)) continue;
            targetView = view;
            break;
        }
        return targetView;
    }

    void bg(Runnable runnable) {
        try {
            this.executor.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            log.warning("GestureReporter: " + e);
        }
    }

    static GestureReporter provideGestureReporter(Activity activity, View rootView) {
        if (!gestureReporterMap.containsKey(activity.hashCode())) {
            currentGestureReporter.set(new GestureReporter(activity, rootView));
            gestureReporterMap.put(activity.hashCode(), currentGestureReporter.get());
        }
        return gestureReporterMap.get(activity.hashCode());
    }

    public static GestureReporter getGestureReporter() {
        return currentGestureReporter.get();
    }

    static GestureReporter getGestureReporter(Activity activity) {
        return gestureReporterMap.get(activity.hashCode());
    }

    static GestureReporter invalidate(Activity activity) {
        GestureReporter reporter = gestureReporterMap.remove(activity.hashCode());
        if (reporter != null) {
            reporter.shutdown();
        }
        currentGestureReporter.compareAndSet(reporter, null);
        return reporter;
    }

    public static void recordOnTouch(View v, MotionEvent event, Map<String, Object> attributes) {
        log.audit("[Gesture] onTouch [" + v.getClass().getSimpleName() + "] MotionEvent[" + event.toString() + "]");
    }

    public static void recordOnClick(final View v, final Map<String, Object> attributes) {
        final GestureReporter gestureReporter = GestureReporter.getGestureReporter();
        if (gestureReporter != null) {
            gestureReporter.bg(new Runnable(){

                @Override
                public void run() {
                    log.audit("[Gesture] onClick [" + v.getClass().getSimpleName() + "]");
                    Map<String, Object> attrs = gestureReporter.createGestureViewAttributes(v);
                    if (attributes != null) {
                        attrs.putAll(attributes);
                    }
                    UserActionFacade.getInstance().recordUserAction(UserActionType.Tap, attrs);
                }
            });
        }
    }

    public static void recordOnLongClick(final View v, final Map<String, Object> attributes) {
        final GestureReporter gestureReporter = GestureReporter.getGestureReporter();
        if (gestureReporter != null) {
            gestureReporter.bg(new Runnable(){

                @Override
                public void run() {
                    log.audit("[Gesture] onLongClick [" + v.getClass().getSimpleName() + "]");
                    Map<String, Object> attrs = gestureReporter.createGestureViewAttributes(v);
                    if (attributes != null) {
                        attrs.putAll(attributes);
                    }
                    UserActionFacade.getInstance().recordUserAction(UserActionType.DoubleTap, attrs);
                }
            });
        }
    }
}

