/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.httpclient.ResponseHandlerImpl;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class ApacheInstrumentation {
    private ApacheInstrumentation() {
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return (T)httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return (T)httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState)), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return (T)httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return (T)httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        TransactionStateUtil.setCatPayload(transactionState);
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(ApacheInstrumentation.delegate(request, transactionState)), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    protected static void httpClientError(TransactionState transactionState, Exception e) {
        if (!transactionState.isComplete()) {
            TransactionStateUtil.setErrorCodeFromException(transactionState, e);
            TransactionData transactionData = transactionState.end();
            if (transactionData != null) {
                transactionData.setResponseBody(e.toString());
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }

    private static HttpUriRequest delegate(HttpUriRequest request, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, request);
    }

    private static HttpRequest delegate(HttpHost host, HttpRequest request, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, host, request);
    }

    private static HttpResponse delegate(HttpResponse response, TransactionState transactionState) {
        return TransactionStateUtil.inspectAndInstrument(transactionState, response);
    }

    private static <T> ResponseHandler<? extends T> delegate(ResponseHandler<? extends T> handler, TransactionState transactionState) {
        return ResponseHandlerImpl.wrap(handler, transactionState);
    }
}

