/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EventManagerImpl
implements EventManager {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String EVENT_TYPE_ALLOWABLE_CHARS = "^[\\p{L}\\p{Nd} _:.]+$";
    public static int DEFAULT_MAX_EVENT_BUFFER_TIME = 600;
    public static int DEFAULT_MAX_EVENT_BUFFER_SIZE = 1000;
    private List<AnalyticsEvent> events;
    private int maxEventPoolSize;
    private int maxBufferTimeInSec;
    private long firstEventTimestamp;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicInteger eventsRecorded = new AtomicInteger(0);
    private AtomicInteger eventsEjected = new AtomicInteger(0);

    public EventManagerImpl() {
        this(DEFAULT_MAX_EVENT_BUFFER_SIZE, DEFAULT_MAX_EVENT_BUFFER_TIME);
    }

    public EventManagerImpl(int maxEventPoolSize, int maxBufferTimeInSec) {
        this.events = Collections.synchronizedList(new ArrayList(maxEventPoolSize));
        this.maxBufferTimeInSec = maxBufferTimeInSec;
        this.maxEventPoolSize = maxEventPoolSize;
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
    }

    @Override
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            log.verbose("EventManagerImpl has already been initialized.  Bypassing...");
            return;
        }
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
        this.empty();
    }

    @Override
    public void shutdown() {
        this.initialized.set(false);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public void empty() {
        this.events.clear();
        this.firstEventTimestamp = 0L;
    }

    @Override
    public boolean isTransmitRequired() {
        return !this.initialized.get() && this.events.size() > 0 || this.isMaxEventBufferTimeExceeded();
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        int eventsRecorded = this.eventsRecorded.incrementAndGet();
        if (this.events.size() == 0) {
            log.verbose("EventManagerImpl.addEvent - Queue is currently empty, setting first event timestamp to " + System.currentTimeMillis());
            this.firstEventTimestamp = System.currentTimeMillis();
        }
        if (this.events.size() >= this.maxEventPoolSize) {
            this.eventsEjected.incrementAndGet();
            int index = (int)(Math.random() * (double)eventsRecorded);
            if (index >= this.maxEventPoolSize) {
                return true;
            }
            this.events.remove(index);
        }
        return this.events.add(event);
    }

    @Override
    public int getEventsRecorded() {
        return this.eventsRecorded.get();
    }

    @Override
    public int getEventsEjected() {
        return this.eventsEjected.get();
    }

    @Override
    public boolean isMaxEventBufferTimeExceeded() {
        if (this.firstEventTimestamp > 0L) {
            return System.currentTimeMillis() - this.firstEventTimestamp > (long)(this.maxBufferTimeInSec * 1000);
        }
        return false;
    }

    @Override
    public boolean isMaxEventPoolSizeExceeded() {
        return this.events.size() > this.maxEventPoolSize;
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.maxEventPoolSize;
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.maxEventPoolSize = maxSize;
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.maxBufferTimeInSec = maxBufferTimeInSec;
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.maxBufferTimeInSec;
    }

    @Override
    public Collection<AnalyticsEvent> getQueuedEvents() {
        return Collections.unmodifiableCollection(this.events);
    }

    public boolean isEventTypeValid(String eventType) {
        boolean valid;
        boolean bl = valid = eventType != null;
        if (valid) {
            valid = eventType.matches(EVENT_TYPE_ALLOWABLE_CHARS);
        }
        if (!valid) {
            log.error("Event type name [" + eventType + "] is invalid and will be ignored. Custom event types may only include alphanumeric, ' ', '.', ':' or '_' characters.");
        }
        return valid;
    }

    public boolean isEventTypeReserved(String eventType) {
        boolean reserved = RESERVED_EVENT_TYPES.contains(eventType);
        if (reserved) {
            log.error("Event type name [" + eventType + "] is reserved and will be ignored.");
        }
        return reserved;
    }

    static {
        RESERVED_EVENT_TYPES.add("Mobile");
        RESERVED_EVENT_TYPES.add("MobileRequest");
        RESERVED_EVENT_TYPES.add("MobileRequestError");
        RESERVED_EVENT_TYPES.add("MobileBreadcrumb");
        RESERVED_EVENT_TYPES.add("MobileCrash");
        RESERVED_EVENT_TYPES.add("MobileUserAction");
    }
}

