/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.gestures;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.gestures.GestureReporter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public class GestureObserver {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static AtomicReference<GestureObserver> instance = new AtomicReference<Object>(null);

    private GestureObserver() {
    }

    public static GestureObserver getInstance() {
        if (instance.compareAndSet(null, new GestureObserver())) {
            log.debug("GestureObserver: instance created");
        }
        return instance.get();
    }

    protected void onActivityStarted(Activity activity) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.pushContext(activity);
        }
    }

    protected void onActivityStopped(Activity activity) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.popContext(activity);
        }
    }

    protected void onFragmentStarted(android.support.v4.app.Fragment fragment) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.pushContext(fragment);
        }
    }

    protected void onFragmentStopped(android.support.v4.app.Fragment fragment) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.popContext(fragment);
        }
    }

    @TargetApi(value=11)
    protected void onFragmentStarted(Fragment fragment) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.pushContext(fragment);
        }
    }

    @TargetApi(value=11)
    protected void onFragmentStopped(Fragment fragment) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation)) {
            this.popContext(fragment);
        }
    }

    @TargetApi(value=11)
    public void onActivityOrFragmentStarted(Object object) {
        if (GestureObserver.isSubClassOf(object, Fragment.class)) {
            Fragment fragment = (Fragment)object;
            this.onFragmentStarted(fragment);
        } else if (GestureObserver.isSubClassOf(object, android.support.v4.app.Fragment.class)) {
            android.support.v4.app.Fragment fragment = (android.support.v4.app.Fragment)object;
            this.onFragmentStarted(fragment);
        } else if (GestureObserver.isSubClassOf(object, Activity.class)) {
            Activity activity = (Activity)object;
            this.onActivityStarted(activity);
        } else {
            log.debug("[Gesture] Received a class we didn't expect [" + object.getClass().getName() + "]");
        }
    }

    @TargetApi(value=11)
    public void onActivityOrFragmentStopped(Object object) {
        if (GestureObserver.isSubClassOf(object, Fragment.class)) {
            Fragment fragment = (Fragment)object;
            this.onFragmentStopped(fragment);
        } else if (GestureObserver.isSubClassOf(object, android.support.v4.app.Fragment.class)) {
            android.support.v4.app.Fragment fragment = (android.support.v4.app.Fragment)object;
            this.onFragmentStopped(fragment);
        } else if (GestureObserver.isSubClassOf(object, Activity.class)) {
            Activity activity = (Activity)object;
            this.onActivityStopped(activity);
        } else {
            log.debug("[Gesture] Received a class we didn't expect [" + object.getClass().getName() + "]");
        }
    }

    public boolean onActivityOrFragmentTouched(MotionEvent event, Object object) {
        Activity activity;
        GestureReporter gestureReporter;
        boolean result = false;
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation) && GestureObserver.isSubClassOf(object, Activity.class) && (gestureReporter = GestureReporter.getGestureReporter(activity = (Activity)object)) != null) {
            gestureReporter.detector.onTouchEvent(event);
        }
        return result;
    }

    public void onActivityBackPressed(Object object) {
        if (FeatureFlag.featureEnabled(FeatureFlag.GestureInstrumentation) && GestureObserver.isSubClassOf(object, Activity.class)) {
            Activity activity = (Activity)object;
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("backPressed", activity.getLocalClassName());
            GestureReporter.recordOnClick(activity.getCurrentFocus(), attributes);
            log.debug("[Gesture] onBackPressed on activity [" + activity.getLocalClassName() + "]");
        }
    }

    void pushContext(Activity activity) {
        View rootView;
        Window rootWindow = activity.getWindow();
        if (rootWindow != null && rootWindow.getDecorView() != null && (rootView = rootWindow.getDecorView().getRootView()) != null && GestureObserver.isSubClassOf(rootView, View.class)) {
            String activityName = activity.getLocalClassName();
            GestureReporter gestureReporter = GestureReporter.getGestureReporter(activity);
            if (gestureReporter == null) {
                GestureReporter.provideGestureReporter(activity, rootView);
                log.debug("[Gesture] Activity started [" + activityName + ":" + Integer.valueOf(activity.hashCode()) + "]");
            }
        }
    }

    @TargetApi(value=11)
    void pushContext(android.support.v4.app.Fragment fragment) {
        View rootView = fragment.getView();
        if (rootView != null && GestureObserver.isSubClassOf(rootView, View.class)) {
            String fragmentName = fragment.getClass().getSimpleName();
            GestureReporter gestureReporter = GestureReporter.getGestureReporter((Activity)fragment.getActivity());
            if (gestureReporter == null) {
                GestureReporter.provideGestureReporter((Activity)fragment.getActivity(), rootView);
                log.debug("[Gesture] Fragment started [" + fragmentName + ":" + Integer.valueOf(fragment.hashCode()) + "]");
            } else {
                gestureReporter.addView(rootView);
            }
        }
    }

    @TargetApi(value=11)
    void pushContext(Fragment fragment) {
        View rootView = fragment.getView();
        if (rootView != null && GestureObserver.isSubClassOf(rootView, View.class)) {
            String fragmentName = fragment.getClass().getSimpleName();
            GestureReporter gestureReporter = GestureReporter.getGestureReporter(fragment.getActivity());
            if (gestureReporter == null) {
                GestureReporter.provideGestureReporter(fragment.getActivity(), rootView);
                log.debug("[Gesture] Fragment started [" + fragmentName + ":" + Integer.valueOf(fragment.hashCode()) + "]");
            } else {
                gestureReporter.addView(rootView);
            }
        }
    }

    void popContext(Activity activity) {
        GestureReporter reporter = GestureReporter.invalidate(activity);
        if (reporter != null) {
            reporter.shutdown();
            log.debug("[Gesture] Activity stopped [" + activity.getLocalClassName() + ":" + Integer.valueOf(activity.hashCode()) + "]");
        }
    }

    private void popContext(Fragment fragment) {
        log.debug("[Gesture] Fragment stopped [" + fragment.getClass().getSimpleName() + ":" + Integer.valueOf(fragment.hashCode()) + "]");
    }

    private void popContext(android.support.v4.app.Fragment fragment) {
        log.debug("[Gesture] Fragment stopped [" + fragment.getClass().getSimpleName() + ":" + Integer.valueOf(fragment.hashCode()) + "]");
    }

    static boolean isSubClassOf(Object instance, Class targetClass) {
        return targetClass.isAssignableFrom(instance.getClass());
    }
}

