/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import com.newrelic.agent.android.gestures.GestureReporter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewListeners {
    static final String AGENT_PACKAGE_NAME = "com.newrelic.agent.android";
    static final String GESTURES_PACKAGE_NAME = "com.newrelic.agent.android.gestures";
    static final String SET_ON_CLICK_LISTENER = "setOnClickListener";
    static final String SET_ON_TOUCH_LISTENER = "setOnTouchListener";
    static final String SET_ON_LONG_CLICK_LISTENER = "setOnLongClickListener";
    static Map<Integer, ListenerElement> listenerCache = new HashMap<Integer, ListenerElement>();

    public static ListenerElement getListenerElement(int viewId) {
        return listenerCache.get(viewId);
    }

    public static void resetTouchCache() {
        listenerCache = new HashMap<Integer, ListenerElement>();
    }

    public static void resetCaches() {
        ViewListeners.resetTouchCache();
    }

    public static class ListenerElement {
        public String targetObject;
        public String methodExecuted;

        public ListenerElement(String targetObject, String methodExecuted) {
            this.targetObject = targetObject;
            this.methodExecuted = methodExecuted;
        }
    }

    static class OnItemClickListenerDelegate
    extends ListenerDelegate<AdapterView.OnItemClickListener>
    implements AdapterView.OnItemClickListener {
        static final String ON_ITEM_CLICK = "onItemClick";

        public OnItemClickListenerDelegate(AdapterView view, AdapterView.OnItemClickListener listener) {
            super((View)view, listener);
        }

        @Override
        String getListenerMethod() {
            return ON_ITEM_CLICK;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            GestureReporter.recordOnClick(parent, this.createListenerAttributes());
            for (AdapterView.OnItemClickListener listener : this.listeners) {
                listener.onItemClick(parent, view, position, id);
            }
        }
    }

    static class OnLongClickListenerDelegate
    extends ListenerDelegate<View.OnLongClickListener>
    implements View.OnLongClickListener {
        static final String ON_LONG_CLICK = "onLongClick";

        public OnLongClickListenerDelegate(View view, View.OnLongClickListener listener) {
            super(view, listener);
        }

        public boolean onLongClick(View view) {
            boolean result = false;
            GestureReporter.recordOnLongClick(view, this.createListenerAttributes());
            for (View.OnLongClickListener listener : this.listeners) {
                result |= listener.onLongClick(view);
            }
            return result;
        }

        @Override
        String getListenerMethod() {
            return ON_LONG_CLICK;
        }
    }

    static class OnTouchListenerDelegate
    extends ListenerDelegate<View.OnTouchListener>
    implements View.OnTouchListener {
        static final String ON_TOUCH = "onTouch";

        public OnTouchListenerDelegate(View view, View.OnTouchListener listener) {
            super(view, listener);
        }

        public boolean onTouch(View view, MotionEvent event) {
            boolean result = false;
            GestureReporter.recordOnTouch(view, event, this.createListenerAttributes());
            for (View.OnTouchListener listener : this.listeners) {
                result |= listener.onTouch(view, event);
            }
            return result;
        }

        @Override
        String getListenerMethod() {
            return ON_TOUCH;
        }
    }

    static class OnClickListenerDelegate
    extends ListenerDelegate<View.OnClickListener>
    implements View.OnClickListener {
        static final String ON_CLICK = "onClick";

        public OnClickListenerDelegate(View view, View.OnClickListener listener) {
            super(view, listener);
        }

        public void onClick(View v) {
            GestureReporter.recordOnClick(v, this.createListenerAttributes());
            for (View.OnClickListener listener : this.listeners) {
                if (listener == null) continue;
                listener.onClick(v);
            }
        }

        @Override
        String getListenerMethod() {
            return ON_CLICK;
        }
    }

    private static abstract class ListenerDelegate<T> {
        final Set<T> listeners = new HashSet<T>();
        final View view;
        protected ListenerElement listenerElement;

        public ListenerDelegate(View view, T listener) {
            this.view = view;
            this.addListener(listener);
        }

        public void addListener(T listener) {
            if (listener == null) {
                return;
            }
            this.listeners.add(listener);
            if (listener.getClass().getName().toLowerCase().startsWith(ViewListeners.GESTURES_PACKAGE_NAME)) {
                return;
            }
            int STARTING_FRAME = 3;
            Thread currentThread = Thread.currentThread();
            if (currentThread.getStackTrace().length > 3) {
                for (int i = 3; i < currentThread.getStackTrace().length; ++i) {
                    StackTraceElement frame = currentThread.getStackTrace()[i];
                    if (frame.getClassName().startsWith(ViewListeners.AGENT_PACKAGE_NAME) || frame.getMethodName().equalsIgnoreCase(ViewListeners.SET_ON_CLICK_LISTENER) || frame.getMethodName().equalsIgnoreCase(ViewListeners.SET_ON_TOUCH_LISTENER) || frame.getMethodName().equalsIgnoreCase(ViewListeners.SET_ON_LONG_CLICK_LISTENER)) continue;
                    String targetObject = listener.getClass().getName() + "#" + this.getListenerMethod();
                    String methodExecuted = frame.getClassName() + "#" + frame.getMethodName();
                    this.listenerElement = new ListenerElement(targetObject, methodExecuted);
                    listenerCache.put(this.view.hashCode(), this.listenerElement);
                    return;
                }
            }
        }

        protected Map<String, Object> createListenerAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (this.listenerElement != null) {
                attributes.put("targetObject", this.listenerElement.targetObject);
                attributes.put("methodExecuted", this.listenerElement.methodExecuted);
            }
            return attributes;
        }

        abstract String getListenerMethod();
    }
}

