/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.payload;

import com.newrelic.agent.android.payload.PayloadSender;
import java.util.concurrent.Callable;

class PayloadReaper
implements Callable<PayloadSender> {
    final PayloadSender sender;
    final PayloadSender.CompletionHandler handler;

    public PayloadReaper(PayloadSender sender, PayloadSender.CompletionHandler handler) {
        if (sender == null) {
            throw new NullPointerException("Must provide payload sender!");
        }
        this.sender = sender;
        this.handler = handler;
    }

    @Override
    public PayloadSender call() throws Exception {
        PayloadSender payloadSender = null;
        try {
            payloadSender = this.sender.call();
            if (this.handler != null) {
                this.handler.onResponse(payloadSender);
            }
            return payloadSender;
        }
        catch (Exception e) {
            if (this.handler != null) {
                this.handler.onException(this.sender, e);
            }
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PayloadReaper) {
            PayloadReaper payloadReaper = (PayloadReaper)o;
            return this.sender.payload.equals(payloadReaper.sender.payload);
        }
        return false;
    }

    public String getUuid() {
        return this.sender.getPayload().getUuid();
    }
}

