/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.instrumentation.io.CountingOutputStream;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpURLConnectionExtension
extends HttpURLConnection {
    private HttpURLConnection impl;
    private TransactionState transactionState;
    private CountingInputStream errorStream = null;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public HttpURLConnectionExtension(HttpURLConnection impl) {
        super(impl.getURL());
        this.impl = impl;
        TransactionStateUtil.setCrossProcessHeader(impl);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setCatPayload(this.getTransactionState());
            try {
                this.impl.addRequestProperty("newrelic", this.transactionState.getCatPayload().asBase64Json());
            }
            catch (NullPointerException e) {
                log.error("Distributed trace payload is null", e);
            }
            catch (IllegalStateException e) {
                log.error("Connection already opened, unable to add Connectivity header", e);
            }
        }
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.impl.addRequestProperty(field, newValue);
    }

    @Override
    public void disconnect() {
        if (this.transactionState != null && !this.transactionState.isComplete()) {
            this.addTransactionAndErrorData(this.transactionState);
        }
        this.impl.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return this.impl.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.getTransactionState();
        try {
            this.impl.connect();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.impl.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this.impl.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        TransactionState transactionState;
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        int contentLength = this.impl.getContentLength();
        if (contentLength >= 0 && !(transactionState = this.getTransactionState()).isComplete()) {
            transactionState.setBytesReceived(contentLength);
            this.addTransactionAndErrorData(transactionState);
        }
        return object;
    }

    public Object getContent(Class[] types) throws IOException {
        Object object;
        this.getTransactionState();
        try {
            object = this.impl.getContent(types);
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return object;
    }

    @Override
    public String getContentEncoding() {
        this.getTransactionState();
        String contentEncoding = this.impl.getContentEncoding();
        this.checkResponse();
        return contentEncoding;
    }

    @Override
    public int getContentLength() {
        this.getTransactionState();
        int contentLength = this.impl.getContentLength();
        this.checkResponse();
        return contentLength;
    }

    @Override
    public String getContentType() {
        this.getTransactionState();
        String contentType = this.impl.getContentType();
        this.checkResponse();
        return contentType;
    }

    @Override
    public long getDate() {
        this.getTransactionState();
        long date = this.impl.getDate();
        this.checkResponse();
        return date;
    }

    @Override
    public InputStream getErrorStream() {
        this.getTransactionState();
        try {
            if (this.errorStream == null || this.errorStream.available() == 0) {
                this.errorStream = new CountingInputStream(this.impl.getErrorStream(), true);
            }
        }
        catch (Exception e) {
            log.error("HttpsURLConnectionExtension: " + e.toString());
            return this.impl.getErrorStream();
        }
        return this.errorStream;
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        this.getTransactionState();
        long date = this.impl.getHeaderFieldDate(field, defaultValue);
        this.checkResponse();
        return date;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.impl.getInstanceFollowRedirects();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.impl.getPermission();
    }

    @Override
    public String getRequestMethod() {
        return this.impl.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        int responseCode;
        this.getTransactionState();
        try {
            responseCode = this.impl.getResponseCode();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        String message;
        this.getTransactionState();
        try {
            message = this.impl.getResponseMessage();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        this.checkResponse();
        return message;
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        this.impl.setChunkedStreamingMode(chunkLength);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.impl.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.impl.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.getTransactionState();
        try {
            this.impl.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            this.error(e);
            throw e;
        }
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.impl.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.impl.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.impl.getDoOutput();
    }

    @Override
    public long getExpiration() {
        this.getTransactionState();
        long expiration = this.impl.getExpiration();
        this.checkResponse();
        return expiration;
    }

    @Override
    public String getHeaderField(int pos) {
        this.getTransactionState();
        String header = this.impl.getHeaderField(pos);
        this.checkResponse();
        return header;
    }

    @Override
    public String getHeaderField(String key) {
        this.getTransactionState();
        String header = this.impl.getHeaderField(key);
        this.checkResponse();
        return header;
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        this.getTransactionState();
        int header = this.impl.getHeaderFieldInt(field, defaultValue);
        this.checkResponse();
        return header;
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        this.getTransactionState();
        String key = this.impl.getHeaderFieldKey(posn);
        this.checkResponse();
        return key;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.getTransactionState();
        Map<String, List<String>> fields = this.impl.getHeaderFields();
        this.checkResponse();
        return fields;
    }

    @Override
    public long getIfModifiedSince() {
        this.getTransactionState();
        long ifModifiedSince = this.impl.getIfModifiedSince();
        this.checkResponse();
        return ifModifiedSince;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        CountingInputStream in;
        final TransactionState transactionState = this.getTransactionState();
        try {
            in = new CountingInputStream(this.impl.getInputStream());
            TransactionStateUtil.inspectAndInstrumentResponse(transactionState, this.impl);
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        in.addStreamCompleteListener(new StreamCompleteListener(){

            @Override
            public void streamError(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    transactionState.setBytesReceived(e.getBytes());
                }
                HttpURLConnectionExtension.this.error(e.getException());
            }

            @Override
            public void streamComplete(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    try {
                        transactionState.setStatusCode(HttpURLConnectionExtension.this.impl.getResponseCode());
                    }
                    catch (IOException ioE) {
                        log.error("HttpURLConnectionExtension.getInputStream.streamComplete: " + e);
                    }
                    long contentLength = HttpURLConnectionExtension.this.impl.getContentLength();
                    long numBytes = e.getBytes();
                    if (contentLength >= 0L) {
                        numBytes = contentLength;
                    }
                    transactionState.setBytesReceived(numBytes);
                    HttpURLConnectionExtension.this.addTransactionAndErrorData(transactionState);
                }
            }
        });
        return in;
    }

    @Override
    public long getLastModified() {
        this.getTransactionState();
        long lastModified = this.impl.getLastModified();
        this.checkResponse();
        return lastModified;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        CountingOutputStream out;
        final TransactionState transactionState = this.getTransactionState();
        try {
            out = new CountingOutputStream(this.impl.getOutputStream());
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        out.addStreamCompleteListener(new StreamCompleteListener(){

            @Override
            public void streamError(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    transactionState.setBytesSent(e.getBytes());
                }
                HttpURLConnectionExtension.this.error(e.getException());
            }

            @Override
            public void streamComplete(StreamCompleteEvent e) {
                if (!transactionState.isComplete()) {
                    try {
                        transactionState.setStatusCode(HttpURLConnectionExtension.this.impl.getResponseCode());
                    }
                    catch (IOException ioE) {
                        log.error("HttpURLConnectionExtension.getOutputStream.streamComplete: " + e);
                    }
                    String header = HttpURLConnectionExtension.this.impl.getRequestProperty("Content-length");
                    long numBytes = e.getBytes();
                    if (header != null) {
                        try {
                            numBytes = Long.parseLong(header);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    transactionState.setBytesSent(numBytes);
                    HttpURLConnectionExtension.this.addTransactionAndErrorData(transactionState);
                }
            }
        });
        return out;
    }

    @Override
    public int getReadTimeout() {
        return this.impl.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.impl.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.impl.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.impl.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.impl.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.impl.setAllowUserInteraction(newValue);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.impl.setConnectTimeout(timeoutMillis);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.impl.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.impl.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.impl.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.impl.setIfModifiedSince(newValue);
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.impl.setReadTimeout(timeoutMillis);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.impl.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.impl.setUseCaches(newValue);
    }

    @Override
    public String toString() {
        return this.impl.toString();
    }

    private void checkResponse() {
        if (!this.getTransactionState().isComplete()) {
            TransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), this.impl);
        }
    }

    TransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new TransactionState();
            TransactionStateUtil.inspectAndInstrument(this.transactionState, this.impl);
        }
        return this.transactionState;
    }

    void error(Exception e) {
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete()) {
            TransactionStateUtil.inspectAndInstrumentResponse(transactionState, this.impl);
            TransactionData transactionData = transactionState.end();
            if (transactionData != null) {
                String responseBody = e.toString();
                try {
                    InputStream errorStream = this.getErrorStream();
                    if (errorStream != null && errorStream instanceof CountingInputStream) {
                        responseBody = ((CountingInputStream)errorStream).getBufferAsString();
                    }
                }
                catch (Exception e1) {
                    log.error("HttpsURLConnectionExtension.error: " + e1.toString());
                }
                transactionData.setResponseBody(responseBody);
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }

    void addTransactionAndErrorData(TransactionState transactionState) {
        TransactionData transactionData = transactionState.end();
        if (transactionData == null) {
            return;
        }
        if (transactionState.isErrorOrFailure()) {
            String responseBody = "";
            try {
                InputStream errorStream = this.getErrorStream();
                if (errorStream instanceof CountingInputStream) {
                    responseBody = ((CountingInputStream)errorStream).getBufferAsString();
                }
            }
            catch (Exception e) {
                log.error("HttpURLConnectionExtension.addTransactionAndErrorData: " + e.toString());
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            String contentType = this.impl.getContentType();
            if (contentType != null && !"".equals(contentType)) {
                params.put("content_type", contentType);
            }
            params.put("content_length", transactionState.getBytesReceived() + "");
            transactionData.setResponseBody(responseBody);
            transactionData.setParams(params);
            Measurements.addHttpError(transactionData);
        }
        TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
    }
}

