/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.TypedValue;
import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class BitmapFactoryInstrumentation {
    private static final ArrayList<String> categoryParams = new ArrayList<String>(Arrays.asList("category", MetricCategory.class.getName(), "IMAGE"));

    private BitmapFactoryInstrumentation() {
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFile(String pathName, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeFile", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFile(String pathName) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeFile", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFile((String)pathName);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeResourceStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResource(Resources res, int id, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeResource", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeResource(Resources res, int id) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeResource", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)id);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeByteArray", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeByteArray", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)offset, (int)length);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)outPadding, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeStream(InputStream is) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeStream", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeFileDescriptor", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)opts);
        TraceMachine.exitMethod();
        return bitmap;
    }

    @ReplaceCallSite(isStatic=true, scope="android.graphics.BitmapFactory")
    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        TraceMachine.enterMethod((String)"BitmapFactory#decodeFileDescriptor", categoryParams);
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
        TraceMachine.exitMethod();
        return bitmap;
    }
}

