/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnalyticAttribute {
    public static final String USER_ID_ATTRIBUTE = "userId";
    public static final String ACCOUNT_ID_ATTRIBUTE = "accountId";
    public static final String APP_ID_ATTRIBUTE = "appId";
    public static final String APP_BUILD_ATTRIBUTE = "appBuild";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String APPLICATION_PLATFORM_ATTRIBUTE = "platform";
    public static final String APPLICATION_PLATFORM_VERSION_ATTRIBUTE = "platformVersion";
    public static final String UUID_ATTRIBUTE = "uuid";
    public static final String OS_NAME_ATTRIBUTE = "osName";
    public static final String OS_VERSION_ATTRIBUTE = "osVersion";
    public static final String OS_MAJOR_VERSION_ATTRIBUTE = "osMajorVersion";
    public static final String OS_BUILD_ATTRIBUTE = "osBuild";
    public static final String ARCHITECTURE_ATTRIBUTE = "architecture";
    public static final String RUNTIME_ATTRIBUTE = "runTime";
    public static final String DEVICE_MANUFACTURER_ATTRIBUTE = "deviceManufacturer";
    public static final String DEVICE_MODEL_ATTRIBUTE = "deviceModel";
    public static final String CARRIER_ATTRIBUTE = "carrier";
    public static final String NEW_RELIC_VERSION_ATTRIBUTE = "newRelicVersion";
    public static final String MEM_USAGE_MB_ATTRIBUTE = "memUsageMb";
    public static final String SESSION_ID_ATTRIBUTE = "sessionId";
    public static final String SESSION_DURATION_ATTRIBUTE = "sessionDuration";
    public static final String SESSION_TIME_SINCE_LOAD_ATTRIBUTE = "timeSinceLoad";
    public static final String INTERACTION_DURATION_ATTRIBUTE = "interactionDuration";
    public static final String LAST_INTERACTION_ATTRIBUTE = "lastInteraction";
    public static final String EVENT_CATEGORY_ATTRIBUTE = "category";
    public static final String EVENT_NAME_ATTRIBUTE = "name";
    public static final String EVENT_TIMESTAMP_ATTRIBUTE = "timestamp";
    public static final String EVENT_TYPE_ATTRIBUTE = "eventType";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE = "Mobile";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE_REQUEST = "MobileRequest";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE_REQUEST_ERROR = "MobileRequestError";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE_BREADCRUMB = "MobileBreadcrumb";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE_CRASH = "MobileCrash";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE_USER_ACTION = "MobileUserAction";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String APP_INSTALL_ATTRIBUTE = "install";
    public static final String APP_UPGRADE_ATTRIBUTE = "upgradeFrom";
    public static final String REQUEST_URL_ATTRIBUTE = "requestUrl";
    public static final String REQUEST_DOMAIN_ATTRIBUTE = "requestDomain";
    public static final String REQUEST_PATH_ATTRIBUTE = "requestPath";
    public static final String REQUEST_METHOD_ATTRIBUTE = "requestMethod";
    public static final String CONNECTION_TYPE_ATTRIBUTE = "connectionType";
    public static final String STATUS_CODE_ATTRIBUTE = "statusCode";
    public static final String BYTES_RECEIVED_ATTRIBUTE = "bytesReceived";
    public static final String BYTES_SENT_ATTRIBUTE = "bytesSent";
    public static final String RESPONSE_TIME_ATTRIBUTE = "responseTime";
    public static final String NETWORK_ERROR_CODE_ATTRIBUTE = "networkErrorCode";
    public static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    public static final String RESPONSE_BODY_ATTRIBUTE = "nr.responseBody";
    public static final String APP_DATA_ATTRIBUTE = "nr.X-NewRelic-App-Data";
    public static final String INSTANT_APP_ATTRIBUTE = "instantApp";
    public static final String NR_GUID_ATTRIBUTE = "guid";
    public static final String NR_TRACEID_ATTRIBUTE = "traceId";
    public static final String NR_PARENTID_ATTRIBUTE = "parentId";
    public static final String ACTION_TYPE_ATTRIBUTE = "actionType";
    public static final String GESTURE_LABEL_ATTRIBUTE = "label";
    public static final String GESTURE_ORIENTATION_ATTRIBUTE = "orientation";
    public static final String GESTURE_COORDINATES_ATTRIBUTE = "touchCoordinates";
    public static final String GESTURE_CONTROL_RECT_ATTRIBUTE = "controlRect";
    public static final String GESTURE_CONTROL_ID_ATTRIBUTE = "controlId";
    public static final String GESTURE_CONTROL_CLASS_ATTRIBUTE = "controlClass";
    public static final String GESTURE_TARGET_OBJECT_ATTRIBUTE = "targetObject";
    public static final String GESTURE_METHOD_EXECUTED_ATTRIBUTE = "methodExecuted";
    public static final String GESTURE_CONTENT_DESCRIPTION_ATTRIBUTE = "contentDescription";
    public static final String GESTURE_BACK_PRESSED_ATTRIBUTE = "backPressed";
    public static final int ATTRIBUTE_NAME_MAX_LENGTH = 256;
    public static final int ATTRIBUTE_VALUE_MAX_LENGTH = 4096;
    private String name;
    private String stringValue;
    private double doubleValue;
    private boolean isPersistent;
    private AttributeDataType attributeDataType;
    protected static Set<String> blackList = new HashSet<String>(){
        {
            this.add(AnalyticAttribute.APP_INSTALL_ATTRIBUTE);
            this.add(AnalyticAttribute.APP_UPGRADE_ATTRIBUTE);
            this.add(AnalyticAttribute.SESSION_DURATION_ATTRIBUTE);
        }
    };

    protected AnalyticAttribute() {
        this.stringValue = null;
        this.doubleValue = Double.NaN;
        this.isPersistent = false;
        this.attributeDataType = AttributeDataType.VOID;
    }

    public AnalyticAttribute(String name, String stringValue) {
        this(name, stringValue, true);
    }

    public AnalyticAttribute(String name, String stringValue, boolean isPersistent) {
        this.name = name;
        this.setStringValue(stringValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticAttribute(String name, double doubleValue) {
        this(name, doubleValue, true);
    }

    public AnalyticAttribute(String name, double doubleValue, boolean isPersistent) {
        this.name = name;
        this.setDoubleValue(doubleValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticAttribute(String name, boolean boolValue) {
        this(name, boolValue, true);
    }

    public AnalyticAttribute(String name, boolean boolValue, boolean isPersistent) {
        this.name = name;
        this.setBooleanValue(boolValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticAttribute(AnalyticAttribute clone) {
        this.name = clone.name;
        this.doubleValue = clone.doubleValue;
        this.stringValue = clone.stringValue;
        this.isPersistent = clone.isPersistent;
        this.attributeDataType = clone.attributeDataType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStringAttribute() {
        return this.attributeDataType == AttributeDataType.STRING;
    }

    public boolean isDoubleAttribute() {
        return this.attributeDataType == AttributeDataType.DOUBLE;
    }

    public boolean isBooleanAttribute() {
        return this.attributeDataType == AttributeDataType.BOOLEAN;
    }

    public String getStringValue() {
        return this.attributeDataType == AttributeDataType.STRING ? this.stringValue : null;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
        this.doubleValue = Double.NaN;
        this.attributeDataType = AttributeDataType.STRING;
    }

    public double getDoubleValue() {
        return this.attributeDataType == AttributeDataType.DOUBLE ? this.doubleValue : Double.NaN;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
        this.stringValue = null;
        this.attributeDataType = AttributeDataType.DOUBLE;
    }

    public boolean getBooleanValue() {
        return this.attributeDataType == AttributeDataType.BOOLEAN ? Boolean.valueOf(this.stringValue) : false;
    }

    public void setBooleanValue(boolean boolValue) {
        this.stringValue = Boolean.toString(boolValue);
        this.doubleValue = Double.NaN;
        this.attributeDataType = AttributeDataType.BOOLEAN;
    }

    public boolean isPersistent() {
        return this.isPersistent && !AnalyticAttribute.isAttributeBlacklisted(this);
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticAttribute attribute = (AnalyticAttribute)o;
        return this.name.equals(attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AnalyticAttribute{");
        stringBuilder.append("name='" + this.name + "'");
        switch (this.attributeDataType) {
            case VOID: {
                break;
            }
            case STRING: {
                stringBuilder.append(",stringValue='" + this.stringValue + "'");
                break;
            }
            case DOUBLE: {
                stringBuilder.append(",doubleValue='" + this.doubleValue + "'");
                break;
            }
            case BOOLEAN: {
                stringBuilder.append(",booleanValue=" + Boolean.valueOf(this.stringValue).toString());
            }
        }
        stringBuilder.append(",isPersistent=" + this.isPersistent);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static boolean isAttributeBlacklisted(AnalyticAttribute attribute) {
        return blackList.contains(attribute.getName());
    }

    public AttributeDataType getAttributeDataType() {
        return this.attributeDataType;
    }

    public String valueAsString() {
        String value;
        switch (this.attributeDataType) {
            case STRING: {
                value = this.stringValue;
                break;
            }
            case DOUBLE: {
                value = Double.toString(this.doubleValue);
                break;
            }
            case BOOLEAN: {
                value = Boolean.valueOf(this.getBooleanValue()).toString();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public JsonElement asJsonElement() {
        JsonPrimitive jsonPrimitive;
        switch (this.attributeDataType) {
            case STRING: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getStringValue());
                break;
            }
            case DOUBLE: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getDoubleValue());
                break;
            }
            case BOOLEAN: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getBooleanValue());
                break;
            }
            default: {
                jsonPrimitive = null;
            }
        }
        return jsonPrimitive;
    }

    public static Set<AnalyticAttribute> newFromJson(JsonObject attributesJson) {
        HashSet<AnalyticAttribute> attributeSet = new HashSet<AnalyticAttribute>();
        for (Map.Entry<String, JsonElement> elem : attributesJson.entrySet()) {
            String key = elem.getKey();
            if (elem.getValue().isJsonPrimitive()) {
                JsonPrimitive value = elem.getValue().getAsJsonPrimitive();
                if (value.isString()) {
                    attributeSet.add(new AnalyticAttribute(key, value.getAsString(), false));
                    continue;
                }
                if (value.isBoolean()) {
                    attributeSet.add(new AnalyticAttribute(key, value.getAsBoolean(), false));
                    continue;
                }
                if (!value.isNumber()) continue;
                attributeSet.add(new AnalyticAttribute(key, value.getAsDouble(), false));
                continue;
            }
            attributeSet.add(new AnalyticAttribute(key, elem.getValue().getAsString(), false));
        }
        return attributeSet;
    }

    public static enum AttributeDataType {
        VOID,
        STRING,
        DOUBLE,
        BOOLEAN;

    }
}

