/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.background;

import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ApplicationStateMonitor {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    protected final ExecutorService executor;
    protected final ArrayList<ApplicationStateListener> applicationStateListeners = new ArrayList();
    protected AtomicBoolean foregrounded = new AtomicBoolean(true);
    private static ApplicationStateMonitor instance = null;
    private AtomicLong activityCount = new AtomicLong(0L);

    public ApplicationStateMonitor() {
        this.executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("AppStateMon"));
        log.info("Application state monitor has started");
    }

    public static ApplicationStateMonitor getInstance() {
        if (instance == null) {
            ApplicationStateMonitor.setInstance(new ApplicationStateMonitor());
        }
        return instance;
    }

    public static void setInstance(ApplicationStateMonitor instance) {
        ApplicationStateMonitor.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.remove(listener);
        }
    }

    public void uiHidden() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (ApplicationStateMonitor.this.foregrounded.get()) {
                    log.info("UI has become hidden (app backgrounded)");
                    ApplicationStateMonitor.this.notifyApplicationInBackground();
                    ApplicationStateMonitor.this.foregrounded.set(false);
                }
            }
        };
        this.executor.execute(runner);
    }

    public void activityStopped() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (ApplicationStateMonitor.this.activityCount.decrementAndGet() == 0L) {
                    ApplicationStateMonitor.this.uiHidden();
                }
            }
        };
        this.executor.execute(runner);
    }

    public void activityStarted() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (ApplicationStateMonitor.this.activityCount.incrementAndGet() == 1L && !ApplicationStateMonitor.this.foregrounded.get()) {
                    ApplicationStateMonitor.this.foregrounded.set(true);
                    ApplicationStateMonitor.this.notifyApplicationInForeground();
                }
            }
        };
        this.executor.execute(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInBackground() {
        ArrayList<ApplicationStateListener> listeners;
        log.verbose("Application appears to have gone to the background");
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationBackgrounded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInForeground() {
        ArrayList<ApplicationStateListener> listeners;
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationForegrounded(e);
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public boolean getForegrounded() {
        return this.foregrounded.get();
    }

    public static boolean isAppInBackground() {
        return !ApplicationStateMonitor.getInstance().getForegrounded();
    }
}

