/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp2;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.okhttp2.PrebufferedResponseBody;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.nio.ByteBuffer;
import java.util.TreeMap;
import okio.Buffer;
import okio.BufferedSource;

public class OkHttp2TransactionStateUtil
extends TransactionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        if (request == null) {
            log.warning("Missing request");
        } else {
            OkHttp2TransactionStateUtil.inspectAndInstrument(transactionState, request.urlString(), request.method());
        }
    }

    public static Response inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = "";
        int statusCode = -1;
        long contentLength = 0L;
        if (response == null) {
            statusCode = 500;
            log.warning("Missing response");
        } else {
            appData = response.header("X-NewRelic-App-Data");
            statusCode = response.code();
            try {
                contentLength = response.body().contentLength();
            }
            catch (Exception e) {
                log.warning("Missing body or content length");
            }
        }
        OkHttp2TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, (int)contentLength, statusCode);
        return OkHttp2TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    protected static Response addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData != null) {
            if (response != null && transactionState.isErrorOrFailure()) {
                String responseBodyString;
                TreeMap<String, String> params;
                block8: {
                    String contentTypeHeader = response.header("Content-Type");
                    params = new TreeMap<String, String>();
                    if (contentTypeHeader != null && contentTypeHeader.length() > 0 && !"".equals(contentTypeHeader)) {
                        params.put("content_type", contentTypeHeader);
                    }
                    params.put("content_length", transactionState.getBytesReceived() + "");
                    responseBodyString = "";
                    try {
                        if (response.body() != null) {
                            ResponseBody body = response.body();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(body.bytes());
                            Buffer buffer = new Buffer().write(byteBuffer.array());
                            PrebufferedResponseBody newBody = new PrebufferedResponseBody(body, (BufferedSource)buffer);
                            response = response.newBuilder().body((ResponseBody)newBody).build();
                            responseBodyString = new String(byteBuffer.array());
                        } else if (response.message() != null) {
                            log.warning("Missing response body, using response message");
                            responseBodyString = response.message();
                        }
                    }
                    catch (Exception e) {
                        if (response.message() == null) break block8;
                        log.warning("Missing response body, using response message");
                        responseBodyString = response.message();
                    }
                }
                transactionData.setResponseBody(responseBodyString);
                transactionData.setParams(params);
                Measurements.addHttpError(transactionData);
            }
            HttpTransactionMeasurement httpTransactionMeasurement = new HttpTransactionMeasurement(transactionData);
            TaskQueue.queue(httpTransactionMeasurement);
        }
        return response;
    }
}

