/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.ApplicationPlatform;
import com.newrelic.agent.android.analytics.AnalyticAttributeStore;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.NullPayloadStore;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadStore;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentConfiguration {
    private static final String DEFAULT_COLLECTOR_HOST = "mobile-collector.newrelic.com";
    private static final String DEFAULT_CRASH_COLLECTOR_HOST = "mobile-crash.newrelic.com";
    public static final String DEFAULT_REGION_COLLECTOR_HOST = "mobile-collector.%s.nr-data.net";
    private static final String DEFAULT_REGION_CRASH_COLLECTOR_HOST = "mobile-crash.%s.nr-data.net";
    private static final String HEX_COLLECTOR_PATH = "/mobile/f";
    private static final int HEX_COLLECTOR_TIMEOUT = 5000;
    private static final int NUM_IO_THREADS = 3;
    private static final int PAYLOAD_TTL = 172800000;
    private String collectorHost = "mobile-collector.newrelic.com";
    private String crashCollectorHost = "mobile-crash.newrelic.com";
    private String applicationToken;
    private String appName;
    private boolean useSsl = true;
    private boolean useLocationService;
    private boolean reportCrashes = true;
    private boolean reportHandledExceptions = true;
    private boolean enableAnalyticsEvents = true;
    private String sessionID = this.provideSessionId();
    private String customApplicationVersion = null;
    private String customBuildId = null;
    private String region = null;
    private CrashStore crashStore;
    private AnalyticAttributeStore analyticAttributeStore;
    private PayloadStore<Payload> payloadStore = new NullPayloadStore<Payload>();
    private ApplicationPlatform applicationPlatform = ApplicationPlatform.Native;
    private String applicationPlatformVersion = Agent.getVersion();

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
        this.region = this.parseRegionFromApplicationToken(applicationToken);
        if (this.region != null) {
            this.collectorHost = String.format(DEFAULT_REGION_COLLECTOR_HOST, this.region);
            this.crashCollectorHost = String.format(DEFAULT_REGION_CRASH_COLLECTOR_HOST, this.region);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getCollectorHost() {
        return this.collectorHost;
    }

    public void setCollectorHost(String collectorHost) {
        this.collectorHost = collectorHost;
    }

    public String getCrashCollectorHost() {
        return this.crashCollectorHost;
    }

    public void setCrashCollectorHost(String crashCollectorHost) {
        this.crashCollectorHost = crashCollectorHost;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean useLocationService() {
        return this.useLocationService;
    }

    public void setUseLocationService(boolean useLocationService) {
        this.useLocationService = useLocationService;
    }

    public boolean getReportCrashes() {
        return this.reportCrashes;
    }

    public void setReportCrashes(boolean reportCrashes) {
        this.reportCrashes = reportCrashes;
    }

    public CrashStore getCrashStore() {
        return this.crashStore;
    }

    public void setCrashStore(CrashStore crashStore) {
        this.crashStore = crashStore;
    }

    public boolean getReportHandledExceptions() {
        return this.reportHandledExceptions;
    }

    public void setReportHandledExceptions(boolean reportHandledExceptions) {
        this.reportHandledExceptions = reportHandledExceptions;
    }

    public AnalyticAttributeStore getAnalyticAttributeStore() {
        return this.analyticAttributeStore;
    }

    public void setAnalyticAttributeStore(AnalyticAttributeStore analyticAttributeStore) {
        this.analyticAttributeStore = analyticAttributeStore;
    }

    public boolean getEnableAnalyticsEvents() {
        return this.enableAnalyticsEvents;
    }

    public void setEnableAnalyticsEvents(boolean enableAnalyticsEvents) {
        this.enableAnalyticsEvents = enableAnalyticsEvents;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getCustomApplicationVersion() {
        return this.customApplicationVersion;
    }

    public void setCustomApplicationVersion(String customApplicationVersion) {
        this.customApplicationVersion = customApplicationVersion;
    }

    public String getCustomBuildIdentifier() {
        return this.customBuildId;
    }

    public void setCustomBuildIdentifier(String customBuildId) {
        this.customBuildId = customBuildId;
    }

    public ApplicationPlatform getApplicationPlatform() {
        return this.applicationPlatform;
    }

    public void setApplicationPlatform(ApplicationPlatform applicationPlatform) {
        this.applicationPlatform = applicationPlatform;
    }

    public String getApplicationPlatformVersion() {
        return this.applicationPlatformVersion == null || this.applicationPlatformVersion.isEmpty() ? Agent.getVersion() : this.applicationPlatformVersion;
    }

    public void setApplicationPlatformVersion(String applicationPlatformVersion) {
        this.applicationPlatformVersion = applicationPlatformVersion;
    }

    protected String provideSessionId() {
        this.sessionID = UUID.randomUUID().toString();
        return this.sessionID;
    }

    public String getHexCollectorPath() {
        return HEX_COLLECTOR_PATH;
    }

    public String getHexCollectorHost() {
        return this.getCollectorHost();
    }

    public int getHexCollectorTimeout() {
        return 5000;
    }

    public String getAppTokenHeader() {
        return "X-App-License-Key";
    }

    public String getAppVersionHeader() {
        return "X-NewRelic-App-Version";
    }

    public String getDeviceOsNameHeader() {
        return "X-NewRelic-OS-Name";
    }

    public int getIOThreadSize() {
        return 3;
    }

    public PayloadStore<Payload> getPayloadStore() {
        return this.payloadStore;
    }

    public void setPayloadStore(PayloadStore<Payload> payloadStore) {
        this.payloadStore = payloadStore;
    }

    public int getPayloadTTL() {
        return 172800000;
    }

    String getDefaultCollectorHost() {
        return DEFAULT_COLLECTOR_HOST;
    }

    String getDefaultCrashCollectorHost() {
        return DEFAULT_CRASH_COLLECTOR_HOST;
    }

    String getRegionalCollectorFromLicenseKey(String key) {
        String region = this.parseRegionFromApplicationToken(key);
        if (region != null && !"".equals(key)) {
            return String.format(DEFAULT_REGION_COLLECTOR_HOST, region);
        }
        return DEFAULT_COLLECTOR_HOST;
    }

    String parseRegionFromApplicationToken(String applicationToken) {
        AgentLog log = AgentLogManager.getAgentLog();
        if (null == applicationToken || "".equals(applicationToken)) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(.+?)x{1,2}.*");
        Matcher matcher = pattern.matcher(applicationToken);
        if (matcher.matches()) {
            try {
                String prefix = matcher.group(1);
                if (prefix != null && !"".equals(prefix)) {
                    return prefix;
                }
                log.warning("Region prefix empty");
            }
            catch (Exception e) {
                log.error("getRegionalCollectorFromLicenseKey: " + e);
            }
        }
        return null;
    }
}

