/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class EventManagerImpl
implements EventManager {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String EVENT_TYPE_ALLOWABLE_CHARS = "^[\\p{L}\\p{Nd} _:.]+$";
    public static int DEFAULT_MAX_EVENT_BUFFER_TIME = 600;
    public static int DEFAULT_MAX_EVENT_BUFFER_SIZE = 1000;
    private AtomicReference<List<AnalyticsEvent>> events;
    private int maxEventPoolSize;
    private int maxBufferTimeInSec;
    private long firstEventTimestamp;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicInteger eventsRecorded = new AtomicInteger(0);
    private AtomicInteger eventsEjected = new AtomicInteger(0);
    private AtomicInteger eventsDropped = new AtomicInteger(0);
    private AtomicBoolean hardFlush = new AtomicBoolean(false);

    public EventManagerImpl() {
        this(DEFAULT_MAX_EVENT_BUFFER_SIZE, DEFAULT_MAX_EVENT_BUFFER_TIME);
    }

    public EventManagerImpl(int maxEventPoolSize, int maxBufferTimeInSec) {
        this.events = new AtomicReference(Collections.synchronizedList(new ArrayList(maxEventPoolSize)));
        this.maxBufferTimeInSec = maxBufferTimeInSec;
        this.maxEventPoolSize = maxEventPoolSize;
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
        this.eventsDropped.set(0);
    }

    @Override
    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            log.verbose("EventManager: Impl has already been initialized. Bypassing...");
            return;
        }
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEjected.set(0);
        this.empty();
    }

    @Override
    public void shutdown() {
        this.initialized.set(false);
    }

    @Override
    public int size() {
        return this.events.get().size();
    }

    @Override
    public void empty() {
        if (this.events.get().size() > 0) {
            log.warning("EventManager: empty() call dropped [" + this.events.get().size() + "] events");
        }
        this.events.get().clear();
        this.firstEventTimestamp = 0L;
    }

    public void empty(Collection<AnalyticsEvent> harvestedEvents) {
        this.events.get().removeAll(harvestedEvents);
    }

    @Override
    public boolean isTransmitRequired() {
        return !this.initialized.get() && this.events.get().size() > 0 || this.hardFlush.compareAndSet(true, false) || this.isMaxEventBufferTimeExceeded();
    }

    @Override
    public void setTransmitRequired() {
        this.hardFlush.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEvent(AnalyticsEvent event) {
        if (!this.initialized.get()) {
            this.eventsDropped.incrementAndGet();
            return false;
        }
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            int recordedCount = this.eventsRecorded.incrementAndGet();
            int snapshotSize = this.events.get().size();
            if (snapshotSize == 0) {
                log.verbose("EventManager: addEvent - Queue is currently empty, setting first event timestamp to " + System.currentTimeMillis());
                this.firstEventTimestamp = System.currentTimeMillis();
            }
            if (snapshotSize >= this.maxEventPoolSize) {
                this.eventsEjected.incrementAndGet();
                int index = (int)(Math.random() * (double)recordedCount);
                if (index >= this.maxEventPoolSize) {
                    return true;
                }
                this.events.get().remove(index);
            }
            return this.events.get().add(event);
        }
    }

    @Override
    public int getEventsRecorded() {
        return this.eventsRecorded.get();
    }

    @Override
    public int getEventsEjected() {
        return this.eventsEjected.get();
    }

    @Override
    public int getEventsDropped() {
        return this.eventsDropped.get();
    }

    @Override
    public boolean isMaxEventBufferTimeExceeded() {
        if (this.firstEventTimestamp > 0L) {
            return System.currentTimeMillis() - this.firstEventTimestamp > (long)(this.maxBufferTimeInSec * 1000);
        }
        return false;
    }

    @Override
    public boolean isMaxEventPoolSizeExceeded() {
        return this.events.get().size() > this.maxEventPoolSize;
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.maxEventPoolSize;
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.maxEventPoolSize = maxSize;
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.maxBufferTimeInSec = maxBufferTimeInSec;
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.maxBufferTimeInSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AnalyticsEvent> getQueuedEvents() {
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            return Collections.unmodifiableCollection((Collection)this.events.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AnalyticsEvent> getQueuedEventsSnapshot() {
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            return this.events.getAndSet(Collections.synchronizedList(new ArrayList(this.maxEventPoolSize)));
        }
    }

    public boolean isEventTypeValid(String eventType) {
        boolean valid;
        boolean bl = valid = eventType != null;
        if (valid) {
            valid = eventType.matches(EVENT_TYPE_ALLOWABLE_CHARS);
        }
        if (!valid) {
            log.error("Event type name [" + eventType + "] is invalid and will be ignored. Custom event types may only include alphanumeric, ' ', '.', ':' or '_' characters.");
        }
        return valid;
    }

    public boolean isEventTypeReserved(String eventType) {
        boolean reserved = RESERVED_EVENT_TYPES.contains(eventType);
        if (reserved) {
            log.error("Event type name [" + eventType + "] is reserved and will be ignored.");
        }
        return reserved;
    }

    static {
        RESERVED_EVENT_TYPES.add("Mobile");
        RESERVED_EVENT_TYPES.add("MobileRequest");
        RESERVED_EVENT_TYPES.add("MobileRequestError");
        RESERVED_EVENT_TYPES.add("MobileBreadcrumb");
        RESERVED_EVENT_TYPES.add("MobileCrash");
        RESERVED_EVENT_TYPES.add("MobileUserAction");
    }
}

