/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.connectivity.CatPayload;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonArray;
import java.util.Map;

public class HttpTransaction
extends HarvestableArray {
    private String url;
    private String httpMethod;
    private String carrier;
    private String wanType;
    private double totalTime;
    private int statusCode;
    private int errorCode;
    private long bytesSent;
    private long bytesReceived;
    private String appData;
    private CatPayload payload;
    private Long timestamp;
    private String responseBody;
    private Map<String, String> params;

    @Override
    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray();
        array.add(SafeJsonPrimitive.factory(this.url));
        array.add(SafeJsonPrimitive.factory(this.carrier));
        array.add(SafeJsonPrimitive.factory(this.totalTime));
        array.add(SafeJsonPrimitive.factory(this.statusCode));
        array.add(SafeJsonPrimitive.factory(this.errorCode));
        array.add(SafeJsonPrimitive.factory(this.bytesSent));
        array.add(SafeJsonPrimitive.factory(this.bytesReceived));
        array.add(this.appData == null ? null : SafeJsonPrimitive.factory(this.appData));
        array.add(SafeJsonPrimitive.factory(this.wanType));
        array.add(SafeJsonPrimitive.factory(this.httpMethod));
        return array;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public void setWanType(String wanType) {
        this.wanType = wanType;
    }

    public void setTotalTime(double totalTime) {
        this.totalTime = totalTime;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public void setAppData(String appData) {
        this.appData = appData;
    }

    public void setResponseBody(String responseBody) {
        if (FeatureFlag.featureEnabled(FeatureFlag.HttpResponseBodyCapture)) {
            this.responseBody = responseBody == null || responseBody.isEmpty() ? null : responseBody;
        }
    }

    public void setCatPayload(CatPayload payload) {
        this.payload = payload;
    }

    public CatPayload getCatPayload() {
        return this.payload;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public String getAppData() {
        return this.appData;
    }

    public String getWanType() {
        return this.wanType;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String toString() {
        return "HttpTransaction{url='" + this.url + '\'' + ", carrier='" + this.carrier + '\'' + ", wanType='" + this.wanType + '\'' + ", httpMethod='" + this.httpMethod + '\'' + ", totalTime=" + this.totalTime + ", statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + ", appData='" + this.appData + '\'' + ", responseBody='" + this.responseBody + '\'' + ", params='" + this.params + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

