/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp2;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.okhttp2.CallbackExtension;
import com.newrelic.agent.android.instrumentation.okhttp2.OkHttp2TransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;

public class CallExtension
extends Call {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private TransactionState transactionState;
    private OkHttpClient client;
    private Request request;
    private Call impl;

    CallExtension(OkHttpClient client, Request request, Call impl, TransactionState transactionState) {
        super(client, request);
        this.client = client;
        this.request = request;
        this.impl = impl;
        this.transactionState = transactionState;
    }

    public Response execute() throws IOException {
        this.getTransactionState();
        Response response = null;
        try {
            response = this.impl.execute();
        }
        catch (IOException e) {
            this.error(e);
            throw e;
        }
        return this.checkResponse(response);
    }

    public void enqueue(Callback responseCallback) {
        this.getTransactionState();
        this.impl.enqueue((Callback)new CallbackExtension(responseCallback, this.transactionState));
    }

    public void cancel() {
        this.impl.cancel();
    }

    public boolean isCanceled() {
        return this.impl.isCanceled();
    }

    private Response checkResponse(Response response) {
        if (!this.getTransactionState().isComplete()) {
            response = OkHttp2TransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), response);
        }
        return response;
    }

    protected TransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new TransactionState();
        }
        OkHttp2TransactionStateUtil.inspectAndInstrument(this.transactionState, this.request);
        return this.transactionState;
    }

    protected void error(Exception e) {
        TransactionData transactionData;
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete() && (transactionData = transactionState.end()) != null) {
            transactionData.setResponseBody(e.toString());
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
        }
    }
}

