/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.text.MessageFormat;

public final class Connectivity {
    private static final String ANDROID = "Android";
    private static AgentLog log = AgentLogManager.getAgentLog();

    public static String carrierNameFromContext(Context context) {
        NetworkInfo networkInfo;
        try {
            networkInfo = Connectivity.getNetworkInfo(context);
        }
        catch (SecurityException e) {
            return "unknown";
        }
        if (!Connectivity.isConnected(networkInfo)) {
            return "none";
        }
        if (Connectivity.isWan(networkInfo)) {
            return Connectivity.carrierNameFromTelephonyManager(context);
        }
        if (Connectivity.isWifi(networkInfo)) {
            return "wifi";
        }
        log.warning(MessageFormat.format("Unknown network type: {0} [{1}]", networkInfo.getTypeName(), networkInfo.getType()));
        return "unknown";
    }

    public static String wanType(Context context) {
        NetworkInfo networkInfo;
        try {
            networkInfo = Connectivity.getNetworkInfo(context);
        }
        catch (SecurityException e) {
            return "unknown";
        }
        if (!Connectivity.isConnected(networkInfo)) {
            return "none";
        }
        if (Connectivity.isWifi(networkInfo)) {
            return "wifi";
        }
        if (Connectivity.isWan(networkInfo)) {
            return Connectivity.connectionNameFromNetworkSubtype(networkInfo.getSubtype());
        }
        return "unknown";
    }

    private static boolean isConnected(NetworkInfo networkInfo) {
        return networkInfo != null && networkInfo.isConnected();
    }

    private static boolean isWan(NetworkInfo networkInfo) {
        switch (networkInfo.getType()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private static boolean isWifi(NetworkInfo networkInfo) {
        switch (networkInfo.getType()) {
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static NetworkInfo getNetworkInfo(Context context) throws SecurityException {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            return connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException e) {
            log.warning("Cannot determine network state. Enable android.permission.ACCESS_NETWORK_STATE in your manifest.");
            throw e;
        }
    }

    private static String carrierNameFromTelephonyManager(Context context) {
        boolean smellsLikeAnEmulator;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String networkOperator = telephonyManager.getNetworkOperatorName();
        if (networkOperator == null || networkOperator.isEmpty()) {
            return "unknown";
        }
        boolean bl = smellsLikeAnEmulator = Build.PRODUCT.equals("google_sdk") || Build.PRODUCT.equals("sdk") || Build.PRODUCT.equals("sdk_x86") || Build.FINGERPRINT.startsWith("generic");
        if (networkOperator.equals(ANDROID) && smellsLikeAnEmulator) {
            return "wifi";
        }
        return networkOperator;
    }

    private static String connectionNameFromNetworkSubtype(int subType) {
        switch (subType) {
            case 7: {
                return "1xRTT";
            }
            case 4: {
                return "CDMA";
            }
            case 2: {
                return "EDGE";
            }
            case 5: {
                return "EVDO rev 0";
            }
            case 6: {
                return "EVDO rev A";
            }
            case 1: {
                return "GPRS";
            }
            case 8: {
                return "HSDPA";
            }
            case 10: {
                return "HSPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 3: {
                return "UMTS";
            }
            case 11: {
                return "IDEN";
            }
            case 12: {
                return "EVDO rev B";
            }
            case 15: {
                return "HSPAP";
            }
            case 14: {
                return "HRPD";
            }
            case 13: {
                return "LTE";
            }
        }
        return "unknown";
    }
}

