/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsAttributeStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedPrefsAnalyticsAttributeStore
extends SharedPrefsStore
implements AnalyticsAttributeStore {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String STORE_FILE = "NRAnalyticsAttributeStore";

    public SharedPrefsAnalyticsAttributeStore(Context context) {
        super(context, STORE_FILE);
    }

    public SharedPrefsAnalyticsAttributeStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(AnalyticsAttribute attribute) {
        SharedPrefsAnalyticsAttributeStore sharedPrefsAnalyticsAttributeStore = this;
        synchronized (sharedPrefsAnalyticsAttributeStore) {
            if (attribute.isPersistent()) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                switch (attribute.getAttributeDataType()) {
                    case STRING: {
                        log.verbose("SharedPrefsAnalyticsAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getStringValue());
                        editor.putString(attribute.getName(), attribute.getStringValue());
                        break;
                    }
                    case DOUBLE: {
                        log.verbose("SharedPrefsAnalyticsAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getDoubleValue());
                        editor.putLong(attribute.getName(), Double.doubleToLongBits(attribute.getDoubleValue()));
                        break;
                    }
                    case BOOLEAN: {
                        log.verbose("SharedPrefsAnalyticsAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getBooleanValue());
                        editor.putBoolean(attribute.getName(), attribute.getBooleanValue());
                        break;
                    }
                    default: {
                        log.error("SharedPrefsAnalyticsAttributeStore.store - unsupported analytic attribute data type" + attribute.getName());
                        return false;
                    }
                }
                return this.applyOrCommitEditor(editor);
            }
        }
        return false;
    }

    @Override
    public List<AnalyticsAttribute> fetchAll() {
        ArrayList<AnalyticsAttribute> analyticsAttributeArrayList = new ArrayList<AnalyticsAttribute>();
        Map storedAttributes = this.sharedPrefs.getAll();
        for (Map.Entry entry : storedAttributes.entrySet()) {
            log.verbose("SharedPrefsAnalyticsAttributeStore.fetchAll - found analytic attribute " + entry.getKey() + "=" + entry.getValue());
            if (entry.getValue() instanceof String) {
                analyticsAttributeArrayList.add(new AnalyticsAttribute(entry.getKey().toString(), entry.getValue().toString(), true));
                continue;
            }
            if (entry.getValue() instanceof Float) {
                analyticsAttributeArrayList.add(new AnalyticsAttribute(entry.getKey().toString(), Double.valueOf(entry.getValue().toString()), true));
                continue;
            }
            if (entry.getValue() instanceof Long) {
                analyticsAttributeArrayList.add(new AnalyticsAttribute(entry.getKey().toString(), Double.longBitsToDouble(Long.valueOf(entry.getValue().toString())), true));
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                analyticsAttributeArrayList.add(new AnalyticsAttribute(entry.getKey().toString(), Boolean.valueOf(entry.getValue().toString()), true));
                continue;
            }
            log.error("SharedPrefsAnalyticsAttributeStore.fetchAll - unsupported analytic attribute " + entry.getKey() + "=" + entry.getValue());
        }
        return analyticsAttributeArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(AnalyticsAttribute attribute) {
        SharedPrefsAnalyticsAttributeStore sharedPrefsAnalyticsAttributeStore = this;
        synchronized (sharedPrefsAnalyticsAttributeStore) {
            log.verbose("SharedPrefsAnalyticsAttributeStore.delete - deleting attribute " + attribute.getName());
            super.delete(attribute.getName());
        }
    }
}

