/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsAttributeStore;
import com.newrelic.agent.android.analytics.AnalyticsController;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.AnalyticsEventFactory;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.analytics.EventManagerImpl;
import com.newrelic.agent.android.analytics.NetworkEventController;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HttpTransaction;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnalyticsControllerImpl
extends HarvestAdapter
implements AnalyticsController {
    protected static final int MAX_ATTRIBUTES = 128;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final AnalyticsControllerImpl instance = new AnalyticsControllerImpl();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Set<String> reservedNames = new HashSet<String>();
    private static final String NEW_RELIC_PREFIX = "newRelic";
    private static final String NR_PREFIX = "nr.";
    private final ConcurrentLinkedQueue<AnalyticsAttribute> systemAttributes;
    private final ConcurrentLinkedQueue<AnalyticsAttribute> userAttributes;
    private final EventManagerImpl eventManager;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final InteractionCompleteListener listener;
    private AgentImpl agentImpl;
    private AnalyticsAttributeStore attributeStore;

    public static void initialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        log.verbose("AnalyticsControllerImpl.initialize invoked.");
        if (agentConfiguration == null || agentImpl == null) {
            log.error("Can't initialize AnalyticsControllerImpl with a null agent configuration or implementation.");
            return;
        }
        if (!initialized.compareAndSet(false, true)) {
            log.warning("AnalyticsControllerImpl has already been initialized. Bypassing..");
            return;
        }
        instance.clear();
        reservedNames.add("eventType");
        reservedNames.add("type");
        reservedNames.add("timestamp");
        reservedNames.add("category");
        reservedNames.add("accountId");
        reservedNames.add("appId");
        reservedNames.add("appName");
        reservedNames.add("uuid");
        reservedNames.add("sessionId");
        reservedNames.add("osName");
        reservedNames.add("osVersion");
        reservedNames.add("osMajorVersion");
        reservedNames.add("deviceManufacturer");
        reservedNames.add("deviceModel");
        reservedNames.add("memUsageMb");
        reservedNames.add("carrier");
        reservedNames.add("newRelicVersion");
        reservedNames.add("interactionDuration");
        reservedNames.add("install");
        reservedNames.add("upgradeFrom");
        reservedNames.add("platform");
        reservedNames.add("platformVersion");
        reservedNames.add("lastInteraction");
        reservedNames.add("osBuild");
        reservedNames.add("runTime");
        reservedNames.add("architecture");
        reservedNames.add("appBuild");
        instance.reinitialize(agentConfiguration, agentImpl);
        TraceMachine.addTraceListener(AnalyticsControllerImpl.instance.listener);
        Harvest.addHarvestListener(instance);
        log.info("Analytics Controller started.");
    }

    public static void shutdown() {
        TraceMachine.removeTraceListener(AnalyticsControllerImpl.instance.listener);
        instance.getEventManager().shutdown();
        initialized.compareAndSet(true, false);
    }

    private AnalyticsControllerImpl() {
        this.eventManager = new EventManagerImpl();
        this.systemAttributes = new ConcurrentLinkedQueue();
        this.userAttributes = new ConcurrentLinkedQueue();
        this.listener = new InteractionCompleteListener();
    }

    void reinitialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        this.agentImpl = agentImpl;
        this.eventManager.initialize();
        this.isEnabled.set(agentConfiguration.getEnableAnalyticsEvents());
        this.attributeStore = agentConfiguration.getAnalyticsAttributeStore();
        this.loadPersistentAttributes();
        DeviceInformation deviceInformation = this.agentImpl.getDeviceInformation();
        String osVersion = deviceInformation.getOsVersion();
        if (osVersion != null && !(osVersion = osVersion.replace(" ", "")).isEmpty()) {
            String osMajorVersion = null;
            String[] osMajorVersionArr = osVersion.split("[.:-]");
            if (osMajorVersionArr.length > 0) {
                osMajorVersion = osMajorVersionArr[0];
            }
            if (osMajorVersion == null || osMajorVersion.isEmpty()) {
                osMajorVersion = osVersion;
            }
            this.systemAttributes.add(new AnalyticsAttribute("osVersion", osVersion));
            this.systemAttributes.add(new AnalyticsAttribute("osMajorVersion", osMajorVersion));
        }
        if (osVersion == null || osVersion.isEmpty()) {
            this.systemAttributes.add(new AnalyticsAttribute("osVersion", "undefined"));
        }
        EnvironmentInformation environmentInformation = this.agentImpl.getEnvironmentInformation();
        this.systemAttributes.add(new AnalyticsAttribute("osName", deviceInformation.getOsName()));
        this.systemAttributes.add(new AnalyticsAttribute("osBuild", deviceInformation.getOsBuild()));
        this.systemAttributes.add(new AnalyticsAttribute("deviceManufacturer", deviceInformation.getManufacturer()));
        this.systemAttributes.add(new AnalyticsAttribute("deviceModel", deviceInformation.getModel()));
        this.systemAttributes.add(new AnalyticsAttribute("uuid", deviceInformation.getDeviceId()));
        this.systemAttributes.add(new AnalyticsAttribute("carrier", agentImpl.getNetworkCarrier()));
        this.systemAttributes.add(new AnalyticsAttribute("newRelicVersion", deviceInformation.getAgentVersion()));
        this.systemAttributes.add(new AnalyticsAttribute("memUsageMb", environmentInformation.getMemoryUsage()));
        this.systemAttributes.add(new AnalyticsAttribute("sessionId", agentConfiguration.getSessionID()));
        this.systemAttributes.add(new AnalyticsAttribute("platform", agentConfiguration.getApplicationPlatform().toString()));
        this.systemAttributes.add(new AnalyticsAttribute("platformVersion", agentConfiguration.getApplicationPlatformVersion()));
        this.systemAttributes.add(new AnalyticsAttribute("runTime", deviceInformation.getRunTime()));
        this.systemAttributes.add(new AnalyticsAttribute("architecture", deviceInformation.getArchitecture()));
        if (agentConfiguration.getCustomBuildIdentifier() != null) {
            this.systemAttributes.add(new AnalyticsAttribute("appBuild", agentConfiguration.getCustomBuildIdentifier()));
        } else {
            String appBuildString = String.valueOf(Agent.getApplicationInformation().getVersionCode());
            if (!appBuildString.isEmpty()) {
                this.systemAttributes.add(new AnalyticsAttribute("appBuild", appBuildString));
            }
        }
    }

    @Override
    public AnalyticsAttribute getAttribute(String name) {
        log.debug("AnalyticsControllerImpl.getAttribute - retrieving " + name);
        AnalyticsAttribute attribute = this.getUserAttribute(name);
        if (attribute == null) {
            attribute = this.getSystemAttribute(name);
        }
        return attribute;
    }

    @Override
    public Set<AnalyticsAttribute> getSystemAttributes() {
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.systemAttributes.size());
        for (AnalyticsAttribute attr : this.systemAttributes) {
            attrs.add(new AnalyticsAttribute(attr));
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticsAttribute> getUserAttributes() {
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.userAttributes.size());
        for (AnalyticsAttribute attr : this.userAttributes) {
            attrs.add(new AnalyticsAttribute(attr));
            if (attrs.size() != 128) continue;
            break;
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticsAttribute> getSessionAttributes() {
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.getSessionAttributeCount());
        attrs.addAll(this.getSystemAttributes());
        attrs.addAll(this.getUserAttributes());
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public int getSystemAttributeCount() {
        return this.systemAttributes.size();
    }

    @Override
    public int getUserAttributeCount() {
        return Math.min(this.userAttributes.size(), 128);
    }

    @Override
    public int getSessionAttributeCount() {
        return this.systemAttributes.size() + this.userAttributes.size();
    }

    @Override
    public boolean setAttribute(String name, String value) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, String value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? "(persistent)" : "(transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name) || !this.isStringValueValid(name, value)) {
            return false;
        }
        AnalyticsAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        attribute.setStringValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, double value) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, double value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticsAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        attribute.setDoubleValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, boolean value) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value);
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, boolean value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticsAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        attribute.setBooleanValue(value);
        attribute.setPersistent(persistent);
        if (attribute.isPersistent()) {
            if (!this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(attribute);
        }
        return true;
    }

    public boolean addAttributeUnchecked(AnalyticsAttribute attribute, boolean persistent) {
        log.debug("AnalyticsControllerImpl.setAttributeUnchecked - " + attribute.getName() + ": " + attribute.getStringValue() + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        String name = attribute.getName();
        if (!this.isNameValid(name)) {
            return false;
        }
        if (attribute.isStringAttribute() && !this.isStringValueValid(name, attribute.getStringValue())) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getSystemAttribute(name);
        if (cachedAttribute == null) {
            this.systemAttributes.add(attribute);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            switch (attribute.getAttributeDataType()) {
                case STRING: {
                    cachedAttribute.setStringValue(attribute.getStringValue());
                    break;
                }
                case DOUBLE: {
                    cachedAttribute.setDoubleValue(attribute.getDoubleValue());
                    break;
                }
                case BOOLEAN: {
                    cachedAttribute.setBooleanValue(attribute.getBooleanValue());
                }
            }
            cachedAttribute.setPersistent(persistent);
            if (cachedAttribute.isPersistent()) {
                if (!this.attributeStore.store(cachedAttribute)) {
                    log.error("Failed to store attribute " + cachedAttribute + " to attribute store.");
                    return false;
                }
            } else {
                this.attributeStore.delete(cachedAttribute);
            }
        }
        return true;
    }

    @Override
    public boolean incrementAttribute(String name, double value) {
        log.debug("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value);
        return this.incrementAttribute(name, value, true);
    }

    @Override
    public boolean incrementAttribute(String name, double value, boolean persistent) {
        log.debug("AnalyticsControllerImpl.incrementAttribute - " + name + ": " + value + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!this.isAttributeNameValid(name)) {
            return false;
        }
        AnalyticsAttribute attribute = this.getAttribute(name);
        if (attribute != null && attribute.isDoubleAttribute()) {
            attribute.setDoubleValue(attribute.getDoubleValue() + value);
            attribute.setPersistent(persistent);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            if (attribute == null) {
                return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
            }
            log.warning("Cannot increment attribute " + name + ": the attribute is already defined as a non-float value.");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAttribute(String name) {
        log.debug("AnalyticsControllerImpl.removeAttribute - " + name);
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        AnalyticsAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            this.userAttributes.remove(attribute);
            if (attribute.isPersistent()) {
                this.attributeStore.delete(attribute);
            }
        }
        return true;
    }

    @Override
    public boolean removeAllAttributes() {
        log.debug("AnalyticsControllerImpl.removeAttributes - ");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        this.attributeStore.clear();
        this.userAttributes.clear();
        return false;
    }

    boolean addEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticsAttribute> eventAttributes, boolean validate) {
        log.debug("AnalyticsControllerImpl.addEvent - " + name + ": category=" + (Object)((Object)eventCategory) + ", eventType: " + eventType + ", eventAttributes:" + eventAttributes);
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticsAttribute> validatedAttributes = new HashSet<AnalyticsAttribute>();
        if (validate) {
            for (AnalyticsAttribute attribute : eventAttributes) {
                if (!this.isAttributeNameValid(attribute.getName())) continue;
                validatedAttributes.add(attribute);
            }
        } else {
            for (AnalyticsAttribute attribute : eventAttributes) {
                if (!this.isNameValid(attribute.getName())) continue;
                validatedAttributes.add(attribute);
            }
        }
        AnalyticsEvent event = AnalyticsEventFactory.createEvent(name, eventCategory, eventType, validatedAttributes);
        return this.addEvent(event);
    }

    @Override
    public boolean addEvent(String name, Set<AnalyticsAttribute> eventAttributes) {
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", eventAttributes);
    }

    @Override
    public boolean addEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticsAttribute> eventAttributes) {
        log.debug("AnalyticsControllerImpl.addEvent - " + name + ": category=" + (Object)((Object)eventCategory) + ", eventType: " + eventType + ", eventAttributes:" + eventAttributes);
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticsAttribute> validatedAttributes = new HashSet<AnalyticsAttribute>();
        for (AnalyticsAttribute attribute : eventAttributes) {
            if (!this.isAttributeNameValid(attribute.getName())) continue;
            validatedAttributes.add(attribute);
        }
        AnalyticsEvent event = AnalyticsEventFactory.createEvent(name, eventCategory, eventType, validatedAttributes);
        return this.addEvent(event);
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>();
        long sessionDuration = this.agentImpl.getSessionDurationMillis();
        if (0L == sessionDuration) {
            log.error("Harvest instance is not running! Session duration will be invalid");
        } else {
            sessionAttributes.add(new AnalyticsAttribute("timeSinceLoad", (float)sessionDuration / 1000.0f));
            event.addAttributes(sessionAttributes);
        }
        return this.eventManager.addEvent(event);
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.eventManager.getMaxEventPoolSize();
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.eventManager.setMaxEventPoolSize(maxSize);
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.eventManager.setMaxEventBufferTime(maxBufferTimeInSec);
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.eventManager.getMaxEventBufferTime();
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public static AnalyticsControllerImpl getInstance() {
        return instance;
    }

    void loadPersistentAttributes() {
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes - loading userAttributes from the attribute store...");
        List<AnalyticsAttribute> storedAttrs = this.attributeStore.fetchAll();
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes - found " + storedAttrs.size() + " userAttributes in the attribute store...");
        int size = this.userAttributes.size();
        for (AnalyticsAttribute attr : storedAttrs) {
            if (this.userAttributes.contains(attr) || size > 128) continue;
            this.userAttributes.add(attr);
            ++size;
        }
    }

    private AnalyticsAttribute getSystemAttribute(String name) {
        AnalyticsAttribute attribute = null;
        for (AnalyticsAttribute nextAttribute : this.systemAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private AnalyticsAttribute getUserAttribute(String name) {
        AnalyticsAttribute attribute = null;
        for (AnalyticsAttribute nextAttribute : this.userAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private void clear() {
        log.debug("AnalyticsControllerImpl.clear - clearing out attributes and events");
        reservedNames.clear();
        this.systemAttributes.clear();
        this.userAttributes.clear();
        this.eventManager.empty();
    }

    private boolean isAttributeNameValid(String name) {
        boolean valid = this.isNameValid(name);
        if (valid) {
            boolean bl = valid = !this.isNameReserved(name);
            if (!valid) {
                log.error("Attribute name " + name + " is reserved for internal use and will be ignored.");
            }
        }
        return valid;
    }

    private boolean isNameValid(String name) {
        boolean valid;
        boolean bl = valid = name != null && !name.equals("") && name.length() < 256;
        if (!valid) {
            log.error("Attribute name " + name + " is null, empty, or exceeds the maximum length of " + 256 + " characters.");
        }
        return valid;
    }

    private boolean isStringValueValid(String name, String value) {
        boolean valid;
        boolean bl = valid = value != null && !value.equals("") && value.getBytes().length < 4096;
        if (!valid) {
            log.error("Attribute value for name " + name + " is null, empty, or exceeds the maximum length of " + 4096 + " bytes.");
        }
        return valid;
    }

    private boolean isNameReserved(String name) {
        if (reservedNames.contains(name)) {
            log.error("Name " + name + " is in the reserved names list.");
            return true;
        }
        if (name.startsWith(NEW_RELIC_PREFIX)) {
            log.error("Name " + name + " starts with reserved prefix " + NEW_RELIC_PREFIX);
            return true;
        }
        if (name.startsWith(NR_PREFIX)) {
            log.error("Name " + name + " starts with reserved prefix " + NR_PREFIX);
            return true;
        }
        return false;
    }

    AnalyticsAttribute createAttribute(String key, Object value) {
        block13: {
            if (this.isAttributeNameValid(key)) {
                try {
                    if (value instanceof String) {
                        String stringValue = String.valueOf(value);
                        if (this.isStringValueValid(key, stringValue)) {
                            return new AnalyticsAttribute(key, stringValue);
                        }
                        break block13;
                    }
                    if (value instanceof Float) {
                        return new AnalyticsAttribute(key, ((Float)value).floatValue());
                    }
                    if (value instanceof Double) {
                        return new AnalyticsAttribute(key, (Double)value);
                    }
                    if (value instanceof Integer) {
                        return new AnalyticsAttribute(key, ((Integer)value).intValue());
                    }
                    if (value instanceof Short) {
                        return new AnalyticsAttribute(key, ((Short)value).shortValue());
                    }
                    if (value instanceof Long) {
                        return new AnalyticsAttribute(key, ((Long)value).longValue());
                    }
                    if (value instanceof BigDecimal) {
                        return new AnalyticsAttribute(key, ((BigDecimal)value).doubleValue());
                    }
                    if (value instanceof BigInteger) {
                        return new AnalyticsAttribute(key, ((BigInteger)value).doubleValue());
                    }
                    if (value instanceof Boolean) {
                        return new AnalyticsAttribute(key, (Boolean)value);
                    }
                    log.error("Unsupported event attribute type for key [" + key + "]: " + value.getClass().getName());
                    return null;
                }
                catch (ClassCastException e) {
                    log.error(String.format("Error casting attribute [%s] to String or Float: ", key), e);
                }
            }
        }
        return null;
    }

    public boolean recordCustomEvent(String eventType, Map<String, Object> eventAttributes) {
        try {
            log.debug("AnalyticsControllerImpl.recordCustomEvent - " + eventType + ": " + eventAttributes.size() + " attributes");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            if (this.eventManager.isEventTypeReserved(eventType) || !this.eventManager.isEventTypeValid(eventType)) {
                return false;
            }
            String eventName = eventType;
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            for (String key : eventAttributes.keySet()) {
                String name;
                Object value;
                AnalyticsAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) continue;
                if (attr.getName().equals("name") && (name = attr.getStringValue()) != null && !name.isEmpty()) {
                    eventName = attr.getStringValue();
                }
                attributes.add(attr);
            }
            return this.addEvent(eventName, AnalyticsEventCategory.Custom, eventType, attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording custom event [%s]: ", eventType), e);
            return false;
        }
    }

    public boolean recordBreadcrumb(String name, Map<String, Object> eventAttributes) {
        try {
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticsAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) continue;
                attributes.add(attr);
            }
            return this.addEvent(name, AnalyticsEventCategory.Breadcrumb, "MobileBreadcrumb", attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording Breadcrumb event [%s]: ", name), e);
            return false;
        }
    }

    public boolean internalRecordEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Map<String, Object> eventAttributes) {
        try {
            log.debug("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            if (!this.eventManager.isEventTypeValid(eventType)) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticsAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) continue;
                attributes.add(attr);
            }
            return this.addEvent(name, eventCategory, eventType, attributes, false);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
            return false;
        }
    }

    public boolean recordEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Map<String, Object> eventAttributes) {
        try {
            log.debug("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            if (!this.eventManager.isEventTypeValid(eventType)) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticsAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) continue;
                attributes.add(attr);
            }
            return this.addEvent(name, eventCategory, eventType, attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
            return false;
        }
    }

    @Override
    public boolean recordEvent(String name, Map<String, Object> eventAttributes) {
        try {
            log.debug("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            for (String key : eventAttributes.keySet()) {
                Object value;
                AnalyticsAttribute attr = this.createAttribute(key, value = eventAttributes.get(key));
                if (attr == null) continue;
                attributes.add(attr);
            }
            return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
            return false;
        }
    }

    void createHttpErrorEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createHttpErrorEvent(txn);
        }
    }

    void createNetworkFailureEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkFailureEvent(txn);
        }
    }

    void createNetworkRequestEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkRequestEvent(txn);
        }
    }

    public void createNetworkRequestEvents(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            if (this.isHttpError(txn)) {
                NetworkEventController.createHttpErrorEvent(txn);
            } else if (this.isNetworkFailure(txn)) {
                NetworkEventController.createNetworkFailureEvent(txn);
            } else if (this.isSuccessfulRequest(txn)) {
                NetworkEventController.createNetworkRequestEvent(txn);
            }
        }
    }

    private boolean isNetworkFailure(HttpTransaction txn) {
        return txn.getErrorCode() != 0;
    }

    private boolean isHttpError(HttpTransaction txn) {
        return (long)txn.getStatusCode() >= 400L;
    }

    private boolean isSuccessfulRequest(HttpTransaction txn) {
        return txn.getStatusCode() > 0 && txn.getStatusCode() < 400;
    }

    private boolean isInitializedAndEnabled() {
        if (!initialized.get()) {
            log.warning("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warning("Analytics controller is not enabled!");
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled.set(enabled);
    }

    private boolean addNewUserAttribute(AnalyticsAttribute attribute) {
        if (this.userAttributes.size() < 128) {
            this.userAttributes.add(attribute);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            log.warning("Attribute limit exceeded: at most 128 are allowed.");
            log.debug("Currently defined attributes:");
            for (AnalyticsAttribute attr : this.userAttributes) {
                log.debug("\t" + attr.getName() + ": " + attr.valueAsString());
            }
        }
        return true;
    }

    @Override
    public void onHarvest() {
        HarvestData harvestData = Harvest.getInstance().getHarvestData();
        if (harvestData != null) {
            harvestData.setAnalyticsEnabled(this.isEnabled.get());
            if (this.isEnabled.get() && FeatureFlag.featureEnabled(FeatureFlag.AnalyticsEvents) && this.eventManager.isTransmitRequired()) {
                HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>();
                sessionAttributes.addAll(this.getSystemAttributes());
                sessionAttributes.addAll(this.getUserAttributes());
                harvestData.setSessionAttributes(sessionAttributes);
                Collection<AnalyticsEvent> pendingEvents = this.eventManager.getQueuedEventsSnapshot();
                if (pendingEvents.size() > 0) {
                    harvestData.getAnalyticsEvents().addAll(pendingEvents);
                    log.debug("EventManager: [" + pendingEvents.size() + "] events moved from buffer to HarvestData");
                }
                if (this.eventManager.getQueuedEvents().size() > 0) {
                    log.error("EventManager: [" + this.eventManager.getQueuedEvents().size() + "] events remain in buffer after hand-off");
                }
            }
        }
    }

    class InteractionCompleteListener
    implements TraceLifecycleAware {
        InteractionCompleteListener() {
        }

        @Override
        public void onEnterMethod() {
        }

        @Override
        public void onExitMethod() {
        }

        @Override
        public void onTraceStart(ActivityTrace activityTrace) {
            AnalyticsAttribute lastInteraction = new AnalyticsAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        @Override
        public void onTraceComplete(ActivityTrace activityTrace) {
            log.verbose("AnalyticsControllerImpl.InteractionCompleteListener.onTraceComplete invoke.");
            AnalyticsEvent event = this.createTraceEvent(activityTrace);
            AnalyticsControllerImpl.getInstance().addEvent(event);
        }

        @Override
        public void onTraceRename(ActivityTrace activityTrace) {
            AnalyticsAttribute lastInteraction = new AnalyticsAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        private AnalyticsEvent createTraceEvent(ActivityTrace activityTrace) {
            float durationInSec = activityTrace.rootTrace.getDurationAsSeconds();
            HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>();
            attrs.add(new AnalyticsAttribute("interactionDuration", durationInSec));
            return AnalyticsEventFactory.createEvent(activityTrace.rootTrace.displayName, AnalyticsEventCategory.Interaction, "Mobile", attrs);
        }
    }
}

