/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class SharedPrefsPayloadStore
extends SharedPrefsStore
implements PayloadStore<Payload> {
    public static final String STORE_FILE = "NRPayloadStore";

    public SharedPrefsPayloadStore(Context context) {
        this(context, STORE_FILE);
    }

    public SharedPrefsPayloadStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    @Override
    public boolean store(Payload payload) {
        LinkedHashSet<String> stringSet = this.toStringSet(payload);
        return super.store(payload.getUuid(), stringSet);
    }

    @Override
    public List<Payload> fetchAll() {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (Object object : super.fetchAll()) {
            if (!(object instanceof HashSet)) continue;
            try {
                HashSet stringSet = (HashSet)object;
                Iterator iter = stringSet.iterator();
                Payload payload = new Gson().fromJson((String)iter.next(), Payload.class);
                payload.putBytes(this.decodePayload((String)iter.next()));
                payloads.add(payload);
            }
            catch (JsonSyntaxException jsonSyntaxException) {}
        }
        return payloads;
    }

    @Override
    public void delete(Payload payload) {
        super.delete(payload.getUuid());
    }

    protected String encodePayload(Payload payload) {
        return this.encodeBytes(payload.getBytes());
    }

    protected byte[] decodePayload(String encodedString) {
        return this.decodeStringToBytes(encodedString);
    }

    protected String decodePayloadToString(byte[] decodedString) {
        return this.decodeBytesToString(decodedString);
    }

    private LinkedHashSet<String> toStringSet(Payload payload) {
        LinkedHashSet<String> stringSet = new LinkedHashSet<String>(2);
        stringSet.add(payload.asJsonMeta());
        stringSet.add(this.encodePayload(payload));
        return stringSet;
    }
}

