/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import java.util.HashSet;
import java.util.Set;

public class AnalyticAttribute {
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String USER_EMAIL_ATTRIBUTE = "email";
    public static final String USER_ID_ATTRIBUTE = "userId";
    public static final String CAMPAIGN_ID_ATTRIBUTE = "campaignId";
    public static final String SESSION_REVENUE_ATTRIBUTE = "sessionRevenue";
    public static final String SUBSCRIPTION_ATTRIBUTE = "subscription";
    public static final String SUBSCRIPTION_REVENUE_ATTRIBUTE = "subscriptionRevenue";
    public static final String ACCOUNT_ID_ATTRIBUTE = "accountId";
    public static final String APP_ID_ATTRIBUTE = "appId";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String UUID_ATTRIBUTE = "uuid";
    public static final String OS_NAME_ATTRIBUTE = "osName";
    public static final String OS_VERSION_ATTRIBUTE = "osVersion";
    public static final String OS_MAJOR_VERSION_ATTRIBUTE = "osMajorVersion";
    public static final String DEVICE_MANUFACTURER_ATTRIBUTE = "deviceManufacturer";
    public static final String DEVICE_MODEL_ATTRIBUTE = "deviceModel";
    public static final String CARRIER_ATTRIBUTE = "carrier";
    public static final String NEW_RELIC_VERSION_ATTRIBUTE = "newRelicVersion";
    public static final String MEM_USAGE_MB_ATTRIBUTE = "memUsageMb";
    public static final String SESSION_ID_ATTRIBUTE = "sessionId";
    public static final String SESSION_DURATION_ATTRIBUTE = "sessionDuration";
    public static final String SESSION_TIME_SINCE_LOAD_ATTRIBUTE = "timeSinceLoad";
    public static final String INTERACTION_DURATION_ATTRIBUTE = "interactionDuration";
    public static final String EVENT_CATEGORY_ATTRIBUTE = "category";
    public static final String EVENT_NAME_ATTRIBUTE = "name";
    public static final String EVENT_TIMESTAMP_ATTRIBUTE = "timestamp";
    public static final String EVENT_TIME_SINCE_LOAD_ATTRIBUTE = "timeSinceLoad";
    public static final String EVENT_SESSION_ELAPSED_TIME_ATTRIBUTE = "sessionElapsedTime";
    public static final String EVENT_TYPE_ATTRIBUTE = "eventType";
    public static final String EVENT_TYPE_ATTRIBUTE_MOBILE = "Mobile";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PURCHASE_EVENT_ATTRIBUTE = "Purchase";
    public static final String PURCHASE_EVENT_SKU_ATTRIBUTE = "sku";
    public static final String PURCHASE_EVENT_QUANTITY_ATTRIBUTE = "quantity";
    public static final String PURCHASE_EVENT_UNIT_PRICE_ATTRIBUTE = "unitprice";
    public static final String PURCHASE_EVENT_TOTAL_PRICE_ATTRIBUTE = "total";
    public static final String APP_INSTALL_ATTRIBUTE = "install";
    public static final String APP_UPGRADE_ATTRIBUTE = "upgradeFrom";
    public static final int ATTRIBUTE_NAME_MAX_LENGTH = 256;
    public static final int ATTRIBUTE_VALUE_MAX_LENGTH = 4096;
    private static final String STRING_ATTRIBUTE_FORMAT = "\"%s\"=\"%s\"";
    private static final String DOUBLE_ATTRIBUTE_FORMAT = "\"%s\"=%f";
    private String name;
    private String stringValue;
    private boolean isStringValue;
    private float floatValue;
    private boolean isPersistent;
    protected static Set<String> blackList = new HashSet<String>(){
        {
            this.add(AnalyticAttribute.APP_INSTALL_ATTRIBUTE);
            this.add(AnalyticAttribute.APP_UPGRADE_ATTRIBUTE);
            this.add(AnalyticAttribute.SESSION_DURATION_ATTRIBUTE);
        }
    };

    public AnalyticAttribute(String name, String stringValue) {
        this(name, stringValue, true);
    }

    public AnalyticAttribute(String name, String stringValue, boolean isPersistent) {
        this.name = name;
        this.stringValue = stringValue;
        this.isStringValue = true;
        this.floatValue = Float.NaN;
        this.isPersistent = isPersistent;
    }

    public AnalyticAttribute(String name, float floatValue) {
        this(name, floatValue, true);
    }

    public AnalyticAttribute(String name, float floatValue, boolean isPersistent) {
        this.name = name;
        this.floatValue = floatValue;
        this.isStringValue = false;
        this.stringValue = null;
        this.isPersistent = isPersistent;
    }

    public AnalyticAttribute(AnalyticAttribute clone) {
        this.name = clone.name;
        this.floatValue = clone.floatValue;
        this.stringValue = clone.stringValue;
        this.isStringValue = clone.isStringValue;
        this.isPersistent = clone.isPersistent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStringAttribute() {
        return this.isStringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
        this.floatValue = Float.NaN;
        this.isStringValue = true;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(float floatValue) {
        this.floatValue = floatValue;
        this.stringValue = null;
        this.isStringValue = false;
    }

    public boolean isPersistent() {
        return this.isPersistent && !AnalyticAttribute.isAttributeBlacklisted(this);
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticAttribute attribute = (AnalyticAttribute)o;
        return this.name.equals(attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "AnalyticAttribute{name='" + this.name + '\'' + (this.isStringAttribute() ? ", stringValue='" + this.stringValue + '\'' : ", floatValue=" + this.floatValue) + ", isPersistent=" + this.isPersistent + '}';
    }

    public static boolean isAttributeBlacklisted(AnalyticAttribute attribute) {
        return blackList.contains(attribute.getName());
    }
}

