/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AnalyticsEvent
extends HarvestableObject {
    private final AgentLog log = AgentLogManager.getAgentLog();
    private String name;
    private long timestamp;
    private AnalyticsEventCategory category;
    private String eventType;
    private Set<AnalyticAttribute> attributeSet = Collections.synchronizedSet(new HashSet());

    protected AnalyticsEvent(String name) {
        this(name, AnalyticsEventCategory.Custom, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category) {
        this(name, category, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category, String eventType, Set<AnalyticAttribute> initialAttributeSet) {
        this.name = name;
        this.category = category == null ? AnalyticsEventCategory.Custom : category;
        this.timestamp = System.currentTimeMillis();
        if (initialAttributeSet != null) {
            for (AnalyticAttribute attribute : initialAttributeSet) {
                this.attributeSet.add(new AnalyticAttribute(attribute));
            }
        }
        if (name != null) {
            this.attributeSet.add(new AnalyticAttribute("name", name));
        }
        this.attributeSet.add(new AnalyticAttribute("timestamp", String.valueOf(this.timestamp)));
        this.attributeSet.add(new AnalyticAttribute("category", category.name()));
        if (eventType != null) {
            this.attributeSet.add(new AnalyticAttribute("eventType", eventType));
        } else {
            this.attributeSet.add(new AnalyticAttribute("eventType", "Mobile"));
        }
    }

    public void addAttributes(Set<AnalyticAttribute> attributeSet) {
        if (attributeSet != null) {
            for (AnalyticAttribute attribute : attributeSet) {
                if (this.attributeSet.add(attribute)) continue;
                this.log.error("Failed to add attribute " + attribute.getName() + " to event " + this.getName() + ": the event already contains that attribute.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AnalyticsEventCategory getCategory() {
        return this.category;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        AnalyticsEvent analyticsEvent = this;
        synchronized (analyticsEvent) {
            for (AnalyticAttribute attribute : this.attributeSet) {
                data.add(attribute.getName(), attribute.isStringAttribute() ? new JsonPrimitive(attribute.getStringValue()) : new JsonPrimitive(Float.valueOf(attribute.getFloatValue())));
            }
        }
        return data;
    }

    public Collection<AnalyticAttribute> getAttributeSet() {
        return Collections.unmodifiableCollection(this.attributeSet);
    }
}

