/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AgentHealthException
extends HarvestableArray {
    private String exceptionClass;
    private String message;
    private String threadName;
    private StackTraceElement[] stackTrace;
    private final AtomicLong count = new AtomicLong(1L);
    private Map<String, String> extras;

    public AgentHealthException(Exception e) {
        this(e, Thread.currentThread().getName());
    }

    public AgentHealthException(Exception e, String threadName) {
        this(e.getClass().getName(), e.getMessage(), threadName, e.getStackTrace());
    }

    public AgentHealthException(String exceptionClass, String message, String threadName, StackTraceElement[] stackTrace) {
        this(exceptionClass, message, threadName, stackTrace, null);
    }

    public AgentHealthException(String exceptionClass, String message, String threadName, StackTraceElement[] stackTrace, Map<String, String> extras) {
        this.exceptionClass = exceptionClass;
        this.message = message;
        this.threadName = threadName;
        this.stackTrace = stackTrace;
        this.extras = extras;
    }

    public void increment() {
        this.count.getAndIncrement();
    }

    public void increment(long i) {
        this.count.getAndAdd(i);
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public String getMessage() {
        return this.message;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public long getCount() {
        return this.count.get();
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public String getSourceClass() {
        return this.stackTrace[0].getClassName();
    }

    public String getSourceMethod() {
        return this.stackTrace[0].getMethodName();
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray data = new JsonArray();
        data.add(new JsonPrimitive(this.exceptionClass));
        data.add(new JsonPrimitive(this.message == null ? "" : this.message));
        data.add(new JsonPrimitive(this.threadName));
        data.add(this.stackTraceToJson());
        data.add(new JsonPrimitive(this.count.get()));
        data.add(this.extrasToJson());
        return data;
    }

    private JsonArray stackTraceToJson() {
        JsonArray stack = new JsonArray();
        for (StackTraceElement element : this.stackTrace) {
            stack.add(new JsonPrimitive(element.toString()));
        }
        return stack;
    }

    private JsonObject extrasToJson() {
        JsonObject data = new JsonObject();
        if (this.extras != null) {
            for (Map.Entry<String, String> entry : this.extras.entrySet()) {
                data.add(entry.getKey(), new JsonPrimitive(entry.getValue()));
            }
        }
        return data;
    }
}

