/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.tracing.SampleValue;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonPrimitive;

public class Sample
extends HarvestableArray {
    private long timestamp;
    private SampleValue sampleValue;
    private SampleType type;

    public Sample(SampleType type) {
        this.setSampleType(type);
        this.setTimestamp(System.currentTimeMillis());
    }

    public Sample(long timestamp) {
        this.setTimestamp(timestamp);
    }

    public Sample(long timestamp, SampleValue sampleValue) {
        this.setTimestamp(timestamp);
        this.setSampleValue(sampleValue);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public SampleValue getSampleValue() {
        return this.sampleValue;
    }

    public void setSampleValue(SampleValue sampleValue) {
        this.sampleValue = sampleValue;
    }

    public void setSampleValue(double value) {
        this.sampleValue = new SampleValue(value);
    }

    public void setSampleValue(long value) {
        this.sampleValue = new SampleValue(value);
    }

    public Number getValue() {
        return this.sampleValue.getValue();
    }

    public SampleType getSampleType() {
        return this.type;
    }

    public void setSampleType(SampleType type) {
        this.type = type;
    }

    @Override
    public JsonArray asJsonArray() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(new JsonPrimitive(this.timestamp));
        jsonArray.add(new JsonPrimitive(this.sampleValue.getValue()));
        return jsonArray;
    }

    public static enum SampleType {
        MEMORY,
        CPU;

    }
}

