/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class PersistentUUID {
    private static final String UUID_KEY = "nr_uuid";
    private static final String UUID_FILENAME = "nr_installation";
    public static final String METRIC_UUID_RECOVERED = "UUIDRecovered";
    private static File UUID_FILE = new File(Environment.getDataDirectory(), "nr_installation");
    private static AgentLog log = AgentLogManager.getAgentLog();

    public PersistentUUID(Context context) {
        UUID_FILE = new File(context.getFilesDir(), UUID_FILENAME);
    }

    public String getDeviceId(Context context) {
        String id = this.generateUniqueID(context);
        if (TextUtils.isEmpty((CharSequence)id)) {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    private String generateUniqueID(Context context) {
        String uuid2;
        String hardwareDeviceId = Build.SERIAL;
        String androidDeviceId = Build.ID;
        try {
            androidDeviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (!TextUtils.isEmpty((CharSequence)androidDeviceId)) {
                try {
                    TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                    if (tm != null) {
                        hardwareDeviceId = tm.getDeviceId();
                    }
                }
                catch (Exception e) {
                    hardwareDeviceId = "badf00d";
                }
                if (TextUtils.isEmpty((CharSequence)hardwareDeviceId)) {
                    hardwareDeviceId = Build.HARDWARE + Build.DEVICE + Build.BOARD + Build.BRAND;
                }
                String uuid2 = this.intToHexString(androidDeviceId.hashCode(), 8) + "-" + this.intToHexString(hardwareDeviceId.hashCode(), 4) + "-" + this.intToHexString(Build.VERSION.SDK_INT, 4) + "-" + this.intToHexString(Build.VERSION.RELEASE.hashCode(), 12);
                throw new RuntimeException("Not supported (TODO)");
            }
            uuid2 = UUID.randomUUID().toString();
        }
        catch (Exception e) {
            uuid2 = UUID.randomUUID().toString();
        }
        return uuid2;
    }

    private String intToHexString(int value, int sublen) {
        String result = "";
        String string = Integer.toHexString(value);
        int remain = sublen - string.length();
        char[] chars = new char[remain];
        Arrays.fill(chars, '0');
        string = new String(chars) + string;
        int count = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            result = string.substring(i, i + 1) + result;
            if (0 != ++count % sublen) continue;
            result = "-" + result;
        }
        if (result.startsWith("-")) {
            result = result.substring(1, result.length());
        }
        return result;
    }

    protected void noticeUUIDMetric(String tag) {
        StatsEngine statsEngine = StatsEngine.get();
        if (statsEngine != null) {
            statsEngine.inc("Supportability/AgentHealth/" + tag);
        } else {
            log.error("StatsEngine is null. " + tag + "  not recorded.");
        }
    }

    public String getPersistentUUID() {
        String uuid = this.getUUIDFromFileStore();
        if (!TextUtils.isEmpty((CharSequence)uuid)) {
            this.noticeUUIDMetric(METRIC_UUID_RECOVERED);
        } else {
            uuid = UUID.randomUUID().toString();
            log.info("Created random UUID: " + uuid);
            StatsEngine.get().inc("Mobile/App/Install");
            this.setPersistedUUID(uuid);
        }
        return uuid;
    }

    protected void setPersistedUUID(String uuid) {
        this.putUUIDToFileStore(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUUIDFromFileStore() {
        String uuid = "";
        if (UUID_FILE.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(UUID_FILE));
                String uuidJson = in.readLine();
                JSONObject jsonObject = new JSONObject(uuidJson);
                uuid = jsonObject.getString(UUID_KEY);
            }
            catch (FileNotFoundException e) {
                log.error(e.getMessage());
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            catch (JSONException e) {
                log.error(e.getMessage());
            }
            catch (NullPointerException e) {
                log.error(e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putUUIDToFileStore(String uuid) {
        BufferedWriter out = null;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(UUID_KEY, (Object)uuid);
            out = new BufferedWriter(new FileWriter(UUID_FILE));
            out.write(jsonObject.toString());
            out.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }
}

