/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.retrofit;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.retrofit.ContentBufferingTypedInput;
import com.newrelic.agent.android.instrumentation.retrofit.RetrofitTransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.TypedInput;

public class ClientExtension
implements Client {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private Client impl;
    private TransactionState transactionState;
    private Request request;

    public ClientExtension(Client impl) {
        this.impl = impl;
    }

    public Response execute(Request request) throws IOException {
        this.request = request;
        this.getTransactionState();
        request = this.setCrossProcessHeader(request);
        Response response = null;
        try {
            response = this.impl.execute(request);
            response = new Response(response.getUrl(), response.getStatus(), response.getReason(), response.getHeaders(), (TypedInput)new ContentBufferingTypedInput(response.getBody()));
        }
        catch (IOException ex) {
            this.error(ex);
            throw ex;
        }
        this.checkResponse(response);
        return response;
    }

    private Request setCrossProcessHeader(Request request) {
        String crossProcessId = Agent.getCrossProcessId();
        if (crossProcessId != null) {
            ArrayList<Header> headers = new ArrayList<Header>(request.getHeaders());
            headers.add(new Header("X-NewRelic-ID".toLowerCase(Locale.ENGLISH), crossProcessId));
            request = new Request(request.getMethod(), request.getUrl(), headers, request.getBody());
        }
        return request;
    }

    private void checkResponse(Response response) {
        if (!this.getTransactionState().isComplete()) {
            RetrofitTransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), response);
        }
    }

    private TransactionState getTransactionState() {
        if (this.transactionState == null) {
            this.transactionState = new TransactionState();
            RetrofitTransactionStateUtil.inspectAndInstrument(this.transactionState, this.request);
        }
        return this.transactionState;
    }

    private void error(Exception e) {
        TransactionData transactionData;
        log.debug("handling exception: " + e.toString());
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete() && (transactionData = transactionState.end()) != null) {
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
        }
    }
}

