/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.crashes.CrashStore;
import com.newrelic.agent.android.harvest.crash.Crash;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonCrashStore
implements CrashStore {
    private static final String STORE_FILE = "NRCrashStore";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final Context context;

    public JsonCrashStore(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Crash crash) {
        JsonCrashStore jsonCrashStore = this;
        synchronized (jsonCrashStore) {
            SharedPreferences store = this.context.getSharedPreferences(STORE_FILE, 0);
            SharedPreferences.Editor editor = store.edit();
            editor.putString(crash.getUuid().toString(), crash.toJsonString());
            editor.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Crash> fetchAll() {
        Map crashStrings;
        SharedPreferences store = this.context.getSharedPreferences(STORE_FILE, 0);
        ArrayList<Crash> crashes = new ArrayList<Crash>();
        JsonCrashStore jsonCrashStore = this;
        synchronized (jsonCrashStore) {
            crashStrings = store.getAll();
        }
        for (Object string : crashStrings.values()) {
            if (!(string instanceof String)) continue;
            try {
                crashes.add(Crash.crashFromJsonString((String)string));
            }
            catch (Exception e) {
                log.error("Exception encountered while deserializing crash", e);
            }
        }
        return crashes;
    }

    @Override
    public int count() {
        SharedPreferences store = this.context.getSharedPreferences(STORE_FILE, 0);
        return store.getAll().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        JsonCrashStore jsonCrashStore = this;
        synchronized (jsonCrashStore) {
            SharedPreferences store = this.context.getSharedPreferences(STORE_FILE, 0);
            SharedPreferences.Editor editor = store.edit();
            editor.clear();
            editor.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Crash crash) {
        JsonCrashStore jsonCrashStore = this;
        synchronized (jsonCrashStore) {
            SharedPreferences store = this.context.getSharedPreferences(STORE_FILE, 0);
            SharedPreferences.Editor editor = store.edit();
            editor.remove(crash.getUuid().toString());
            editor.commit();
        }
    }
}

