/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.background;

import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ApplicationStateMonitor
implements Runnable {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private AtomicLong count = new AtomicLong(0L);
    private AtomicLong snoozeStartTime = new AtomicLong(0L);
    private final Lock snoozeLock = new ReentrantLock();
    private final int activitySnoozeTimeInMilliseconds;
    protected final ArrayList<ApplicationStateListener> applicationStateListeners = new ArrayList();
    protected AtomicBoolean foregrounded = new AtomicBoolean(true);
    private final Lock foregroundLock = new ReentrantLock();
    private static ApplicationStateMonitor instance;
    protected final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("AppStateMon"));

    private ApplicationStateMonitor() {
        this(5, 5, TimeUnit.SECONDS, 5000);
    }

    ApplicationStateMonitor(int initialDelay, int period, TimeUnit timeUnit, int snoozeTimeInMilliseconds) {
        this.activitySnoozeTimeInMilliseconds = snoozeTimeInMilliseconds;
        this.executor.scheduleAtFixedRate(this, initialDelay, period, timeUnit);
        log.info("Application state monitor has started");
    }

    public static ApplicationStateMonitor getInstance() {
        if (instance == null) {
            instance = new ApplicationStateMonitor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationStateListener(ApplicationStateListener listener) {
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            this.applicationStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.foregroundLock.lock();
            if (this.foregrounded.get() && this.getSnoozeTime() >= (long)this.activitySnoozeTimeInMilliseconds) {
                this.foregrounded.set(false);
                this.notifyApplicationInBackground();
            }
        }
        finally {
            this.foregroundLock.unlock();
        }
    }

    public void uiHidden() {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ApplicationStateMonitor.this.foregroundLock.lock();
                    if (ApplicationStateMonitor.this.foregrounded.get()) {
                        log.info("UI has become hidden (app backgrounded)");
                        ApplicationStateMonitor.this.notifyApplicationInBackground();
                        ApplicationStateMonitor.this.foregrounded.set(false);
                    }
                }
                finally {
                    ApplicationStateMonitor.this.foregroundLock.unlock();
                }
            }
        };
        this.executor.execute(runner);
    }

    public void activityStopped() {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ApplicationStateMonitor.this.foregroundLock.lock();
                    try {
                        ApplicationStateMonitor.this.snoozeLock.lock();
                        if (ApplicationStateMonitor.this.count.decrementAndGet() == 0L) {
                            ApplicationStateMonitor.this.snoozeStartTime.set(System.currentTimeMillis());
                        }
                    }
                    finally {
                        ApplicationStateMonitor.this.snoozeLock.unlock();
                    }
                }
                finally {
                    ApplicationStateMonitor.this.foregroundLock.unlock();
                }
            }
        };
        this.executor.execute(runner);
    }

    public void activityStarted() {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ApplicationStateMonitor.this.foregroundLock.lock();
                    try {
                        ApplicationStateMonitor.this.snoozeLock.lock();
                        if (ApplicationStateMonitor.this.count.incrementAndGet() == 1L) {
                            ApplicationStateMonitor.this.snoozeStartTime.set(0L);
                        }
                    }
                    finally {
                        ApplicationStateMonitor.this.snoozeLock.unlock();
                    }
                    if (!ApplicationStateMonitor.this.foregrounded.get()) {
                        log.verbose("Application appears to be in the foreground");
                        ApplicationStateMonitor.this.foregrounded.set(true);
                        ApplicationStateMonitor.this.notifyApplicationInForeground();
                    }
                }
                finally {
                    ApplicationStateMonitor.this.foregroundLock.unlock();
                }
            }
        };
        this.executor.execute(runner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInBackground() {
        ArrayList<ApplicationStateListener> listeners;
        log.verbose("Application appears to have gone to the background");
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationBackgrounded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplicationInForeground() {
        ArrayList<ApplicationStateListener> listeners;
        ArrayList<ApplicationStateListener> arrayList = this.applicationStateListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<ApplicationStateListener>(this.applicationStateListeners);
        }
        ApplicationStateEvent e = new ApplicationStateEvent(this);
        for (ApplicationStateListener listener : listeners) {
            listener.applicationForegrounded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSnoozeTime() {
        long snoozeValue = 0L;
        try {
            this.foregroundLock.lock();
            try {
                this.snoozeLock.lock();
                long snoozeTime = this.snoozeStartTime.get();
                if (snoozeTime != 0L) {
                    snoozeValue = System.currentTimeMillis() - snoozeTime;
                }
            }
            finally {
                this.snoozeLock.unlock();
            }
        }
        finally {
            this.foregroundLock.unlock();
        }
        return snoozeValue;
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public boolean getForegrounded() {
        return this.foregrounded.get();
    }

    public static boolean isAppInBackground() {
        return !ApplicationStateMonitor.getInstance().getForegrounded();
    }
}

