/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crashes;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.crashes.CrashStore;
import com.newrelic.agent.android.harvest.crash.Crash;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CrashReporter {
    private static final String CRASH_COLLECTOR_PATH = "/mobile_crash";
    private static final int CRASH_COLLECTOR_TIMEOUT = 5000;
    protected static CrashReporter instance = new CrashReporter();
    private static AgentConfiguration agentConfiguration;
    private static ExecutorService executor;
    private final AgentLog log = AgentLogManager.getAgentLog();
    protected boolean isEnabled = false;
    private boolean reportCrashes = true;
    private Thread.UncaughtExceptionHandler previousExceptionHandler;
    private CrashStore crashStore;
    protected static final AtomicBoolean initialized;

    public static void initialize(AgentConfiguration _agentConfiguration) {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        executor = Executors.newCachedThreadPool(new NamedThreadFactory("CrashUploader"));
        agentConfiguration = _agentConfiguration;
        CrashReporter.instance.isEnabled = agentConfiguration.getReportCrashes();
        CrashReporter.instance.crashStore = agentConfiguration.getCrashStore();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                if (instance.hasReachableNetworkConnection()) {
                    instance.reportSavedCrashes();
                    instance.reportSupportabilityMetrics();
                } else {
                    instance.log.warning("Unable to upload cached crash to New Relic - no network");
                }
            }
        });
        if (CrashReporter.instance.isEnabled) {
            instance.installCrashHandler();
        }
    }

    public static AgentConfiguration getAgentConfiguration() {
        return agentConfiguration;
    }

    public UncaughtExceptionHandler getHandler() {
        return new UncaughtExceptionHandler();
    }

    public static UncaughtExceptionHandler getInstanceHandler() {
        return instance.getHandler();
    }

    public static void setReportCrashes(boolean reportCrashes) {
        CrashReporter.instance.reportCrashes = reportCrashes;
    }

    public static int getStoredCrashCount() {
        return CrashReporter.instance.crashStore.count();
    }

    public static List<Crash> fetchAllCrashes() {
        return CrashReporter.instance.crashStore.fetchAll();
    }

    public static void clear() {
        CrashReporter.instance.crashStore.clear();
    }

    private void installCrashHandler() {
        Thread.UncaughtExceptionHandler currentExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentExceptionHandler != null) {
            if (currentExceptionHandler instanceof UncaughtExceptionHandler) {
                this.log.debug("New Relic crash handler already installed.");
                return;
            }
            this.previousExceptionHandler = currentExceptionHandler;
            this.log.debug("Installing New Relic crash handler and chaining " + this.previousExceptionHandler.getClass().getName());
        } else {
            this.log.debug("Installing New Relic crash handler.");
        }
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    protected void reportSavedCrashes() {
        for (Crash crash : this.crashStore.fetchAll()) {
            if (crash.isStale()) {
                this.crashStore.delete(crash);
                this.log.info("Crash [" + crash.getUuid().toString() + "] has become stale, and has been removed");
                StatsEngine.get().inc("Supportability/AgentHealth/Crash/Removed/Stale");
                continue;
            }
            this.reportCrash(crash);
        }
    }

    protected Future<?> reportCrash(Crash crash) {
        Future<?> crashSenderThread = null;
        if (this.reportCrashes) {
            CrashSender sender = new CrashSender(crash);
            crashSenderThread = executor.submit(sender);
        }
        return crashSenderThread;
    }

    protected void recordFailedUpload(String errorMsg) {
        this.log.error(errorMsg);
        StatsEngine.get().inc("Supportability/AgentHealth/Crash/FailedUpload");
    }

    protected void storeSupportabilityMetrics() {
        ConcurrentHashMap<String, Metric> statsMap = StatsEngine.get().getStatsMap();
    }

    protected void reportSupportabilityMetrics() {
    }

    private boolean requestWasSuccessful(HttpURLConnection connection) throws IOException {
        switch (connection.getResponseCode()) {
            case 200: {
                return true;
            }
        }
        this.log.error("[crashsender] Server returned " + Integer.valueOf(connection.getResponseCode()).toString());
        return false;
    }

    private boolean hasReachableNetworkConnection() {
        boolean isReachable = false;
        try {
            InetAddress addr = InetAddress.getByName(agentConfiguration.getCrashCollectorHost());
            isReachable = addr.isReachable(5000);
        }
        catch (IOException e) {
            isReachable = false;
        }
        return isReachable;
    }

    static {
        initialized = new AtomicBoolean(false);
    }

    private class CrashSender
    implements Runnable {
        private final Crash crash;

        CrashSender(Crash crash) {
            this.crash = crash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                protocol = CrashReporter.access$200().useSsl() != false ? "https://" : "http://";
                urlString = protocol + CrashReporter.access$200().getCrashCollectorHost() + "/mobile_crash";
                url = new URL(urlString);
                connection = (HttpURLConnection)url.openConnection();
                timer = new TicToc();
                timer.tic();
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                try {
                    this.crash.incrementUploadCount();
                    CrashReporter.access$300(CrashReporter.this).store(this.crash);
                    out = new BufferedOutputStream(connection.getOutputStream());
                    out.write(this.crash.toJsonString().getBytes());
                    out.close();
                    switch (connection.getResponseCode()) {
                        case 200: {
                            CrashReporter.access$300(CrashReporter.this).delete(this.crash);
                            StatsEngine.get().sampleTimeMs("Supportability/AgentHealth/Crash/UploadTime", timer.peek());
                            CrashReporter.access$100(CrashReporter.this).info("Crash " + this.crash.getUuid().toString() + " successfully submitted.");
                            ** break;
lbl25:
                            // 1 sources

                            break;
                        }
                        case 500: {
                            CrashReporter.access$300(CrashReporter.this).delete(this.crash);
                            StatsEngine.get().inc("Supportability/AgentHealth/Crash/Removed/Rejected");
                            CrashReporter.this.recordFailedUpload("The crash was rejected and will be deleted - Response code " + connection.getResponseCode());
                            ** break;
lbl31:
                            // 1 sources

                            break;
                        }
                        default: {
                            CrashReporter.this.recordFailedUpload("Something went wrong while submitting a crash (will try again later) - Response code " + connection.getResponseCode());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    CrashReporter.this.recordFailedUpload("Crash upload failed: " + e);
                }
                finally {
                    connection.disconnect();
                }
                CrashReporter.access$100(CrashReporter.this).debug("Crash collection took " + timer.toc() + "ms");
            }
            catch (Exception e) {
                CrashReporter.this.recordFailedUpload("Unable to report crash to New Relic, will try again later. " + e);
            }
        }
    }

    public class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean handledException = new AtomicBoolean(false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!Agent.getUnityInstrumentationFlag().equals("YES") && !this.handledException.compareAndSet(false, true)) {
                StatsEngine.get().inc("Supportability/AgentHealth/Recursion/UncaughtExceptionHandler");
                return;
            }
            try {
                if (!CrashReporter.instance.isEnabled || !FeatureFlag.featureEnabled(FeatureFlag.CrashReporting)) {
                    CrashReporter.this.log.debug("A crash has been detected but crash reporting is disabled!");
                    this.chainExceptionHandler(thread, throwable);
                    return;
                }
                CrashReporter.this.log.debug("A crash has been detected in " + thread.getStackTrace()[0].getClassName() + " and will be reported ASAP.");
                CrashReporter.this.log.debug("Analytics data is currently " + (agentConfiguration.getEnableAnalyticsEvents() ? "enabled " : "disabled"));
                Crash crash = new Crash(throwable, AnalyticsControllerImpl.getInstance().getSessionAttributes(), AnalyticsControllerImpl.getInstance().getEventManager().getQueuedEvents(), agentConfiguration.getEnableAnalyticsEvents());
                try {
                    CrashReporter.this.crashStore.store(crash);
                    CrashReporter.this.reportCrash(crash);
                    if (!Agent.getUnityInstrumentationFlag().equals("YES")) {
                        executor.shutdown();
                        if (!executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                            CrashReporter.this.recordFailedUpload("Crash upload thread(s) timed-out before completion");
                        }
                    }
                }
                catch (Exception e) {
                    CrashReporter.this.recordFailedUpload("Exception caught while sending crash: " + e);
                }
            }
            catch (Throwable t) {
                CrashReporter.this.recordFailedUpload("Error encountered while preparing crash for New Relic! " + t);
            }
            finally {
                CrashReporter.this.storeSupportabilityMetrics();
                if (!Agent.getUnityInstrumentationFlag().equals("YES")) {
                    this.chainExceptionHandler(thread, throwable);
                }
            }
        }

        private void chainExceptionHandler(Thread thread, Throwable throwable) {
            if (CrashReporter.this.previousExceptionHandler != null) {
                CrashReporter.this.log.debug("Chaining crash reporting duties to " + CrashReporter.this.previousExceptionHandler.getClass().getSimpleName());
                CrashReporter.this.previousExceptionHandler.uncaughtException(thread, throwable);
            }
        }
    }
}

