/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.ApplicationPlatform;
import com.newrelic.agent.android.harvest.type.HarvestableArray;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class DeviceInformation
extends HarvestableArray {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private String osName;
    private String osVersion;
    private String osBuild;
    private String model;
    private String agentName;
    private String agentVersion;
    private String deviceId;
    private String countryCode;
    private String regionCode;
    private String manufacturer;
    private String architecture;
    private String runTime;
    private String size;
    private ApplicationPlatform applicationPlatform;
    private String applicationPlatformVersion;
    private Map<String, String> misc = new HashMap<String, String>();

    @Override
    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray();
        this.notEmpty(this.osName);
        array.add(new JsonPrimitive(this.osName));
        this.notEmpty(this.osVersion);
        array.add(new JsonPrimitive(this.osVersion));
        this.notEmpty(this.manufacturer);
        this.notEmpty(this.model);
        array.add(new JsonPrimitive(this.manufacturer + " " + this.model));
        this.notEmpty(this.agentName);
        array.add(new JsonPrimitive(this.agentName));
        this.notEmpty(this.agentVersion);
        array.add(new JsonPrimitive(this.agentVersion));
        this.notEmpty(this.deviceId);
        array.add(new JsonPrimitive(this.deviceId));
        array.add(new JsonPrimitive(this.optional(this.countryCode)));
        array.add(new JsonPrimitive(this.optional(this.regionCode)));
        array.add(new JsonPrimitive(this.manufacturer));
        HashMap<String, String> miscMap = new HashMap<String, String>();
        if (this.misc != null && !this.misc.isEmpty()) {
            miscMap.putAll(this.misc);
        }
        if (this.applicationPlatform != null) {
            miscMap.put("platform", this.applicationPlatform.toString());
            if (this.applicationPlatformVersion != null) {
                miscMap.put("platformVersion", this.applicationPlatformVersion);
            }
        }
        JsonElement map = new Gson().toJsonTree(miscMap, GSON_STRING_MAP_TYPE);
        array.add(map);
        return array;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOsBuild(String osBuild) {
        this.osBuild = osBuild;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public void setSize(String size) {
        this.size = size;
        this.addMisc("size", size);
    }

    public void setApplicationPlatform(ApplicationPlatform applicationPlatform) {
        this.applicationPlatform = applicationPlatform;
    }

    public void setApplicationPlatformVersion(String applicationPlatformVersion) {
        this.applicationPlatformVersion = applicationPlatformVersion;
    }

    public void setMisc(Map<String, String> misc) {
        this.misc = new HashMap<String, String>(misc);
    }

    public void addMisc(String key, String value) {
        this.misc.put(key, value);
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsBuild() {
        return this.osBuild;
    }

    public String getModel() {
        return this.model;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getRunTime() {
        return this.runTime;
    }

    public String getSize() {
        return this.size;
    }

    public ApplicationPlatform getApplicationPlatform() {
        return this.applicationPlatform;
    }

    public String getApplicationPlatformVersion() {
        return this.applicationPlatformVersion;
    }

    @Override
    public String toJsonString() {
        return "DeviceInformation{manufacturer='" + this.manufacturer + '\'' + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", model='" + this.model + '\'' + ", agentName='" + this.agentName + '\'' + ", agentVersion='" + this.agentVersion + '\'' + ", deviceId='" + this.deviceId + '\'' + ", countryCode='" + this.countryCode + '\'' + ", regionCode='" + this.regionCode + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInformation that = (DeviceInformation)o;
        if (this.agentName != null ? !this.agentName.equals(that.agentName) : that.agentName != null) {
            return false;
        }
        if (this.agentVersion != null ? !this.agentVersion.equals(that.agentVersion) : that.agentVersion != null) {
            return false;
        }
        if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) {
            return false;
        }
        if (this.deviceId != null ? !this.deviceId.equals(that.deviceId) : that.deviceId != null) {
            return false;
        }
        if (this.manufacturer != null ? !this.manufacturer.equals(that.manufacturer) : that.manufacturer != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(that.model) : that.model != null) {
            return false;
        }
        if (this.osBuild != null ? !this.osBuild.equals(that.osBuild) : that.osBuild != null) {
            return false;
        }
        if (this.osName != null ? !this.osName.equals(that.osName) : that.osName != null) {
            return false;
        }
        if (this.osVersion != null ? !this.osVersion.equals(that.osVersion) : that.osVersion != null) {
            return false;
        }
        if (this.runTime != null ? !this.runTime.equals(that.runTime) : that.runTime != null) {
            return false;
        }
        return !(this.size != null ? !this.size.equals(that.size) : that.size != null);
    }

    public int hashCode() {
        int result = this.osName != null ? this.osName.hashCode() : 0;
        result = 31 * result + (this.osVersion != null ? this.osVersion.hashCode() : 0);
        result = 31 * result + (this.osBuild != null ? this.osBuild.hashCode() : 0);
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + (this.agentName != null ? this.agentName.hashCode() : 0);
        result = 31 * result + (this.agentVersion != null ? this.agentVersion.hashCode() : 0);
        result = 31 * result + (this.deviceId != null ? this.deviceId.hashCode() : 0);
        result = 31 * result + (this.manufacturer != null ? this.manufacturer.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        result = 31 * result + (this.runTime != null ? this.runTime.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        return result;
    }
}

