/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.tracing;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.v2.TraceFieldInterface;
import com.newrelic.agent.android.api.v2.TraceMachineInterface;
import com.newrelic.agent.android.harvest.ActivityHistory;
import com.newrelic.agent.android.harvest.ActivitySighting;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Trace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceType;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import com.newrelic.agent.android.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class TraceMachine
extends HarvestAdapter {
    public static final String NR_TRACE_FIELD = "_nr_trace";
    public static final String NR_TRACE_TYPE = "Lcom/newrelic/agent/android/tracing/Trace;";
    public static final String ACTIVITY_METRIC_PREFIX = "Mobile/Activity/Name/";
    public static final String ACTIVITY_BACKGROUND_METRIC_PREFIX = "Mobile/Activity/Background/Name/";
    public static final String ACTIVTY_DISPLAY_NAME_PREFIX = "Display ";
    public static final AtomicBoolean enabled = new AtomicBoolean(true);
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final int HEALTHY_TRACE_TIMEOUT = 500;
    public static final int UNHEALTHY_TRACE_TIMEOUT = 60000;
    private static final Collection<TraceLifecycleAware> traceListeners = new CopyOnWriteArrayList<TraceLifecycleAware>();
    private static final ThreadLocal<Trace> threadLocalTrace = new ThreadLocal();
    private static final ThreadLocal<TraceStack> threadLocalTraceStack = new ThreadLocal();
    private static final List<ActivitySighting> activityHistory = new CopyOnWriteArrayList<ActivitySighting>();
    private static TraceMachine traceMachine = null;
    private static TraceMachineInterface traceMachineInterface;
    private ActivityTrace activityTrace;

    protected static boolean isEnabled() {
        return enabled.get() && FeatureFlag.featureEnabled(FeatureFlag.InteractionTracing);
    }

    protected TraceMachine(Trace rootTrace) {
        this.activityTrace = new ActivityTrace(rootTrace);
        Harvest.addHarvestListener(this);
    }

    public static TraceMachine getTraceMachine() {
        return traceMachine;
    }

    public static void addTraceListener(TraceLifecycleAware listener) {
        traceListeners.add(listener);
    }

    public static void removeTraceListener(TraceLifecycleAware listener) {
        traceListeners.remove(listener);
    }

    public static void setTraceMachineInterface(TraceMachineInterface traceMachineInterface) {
        TraceMachine.traceMachineInterface = traceMachineInterface;
    }

    public static void startTracing(String name) {
        TraceMachine.startTracing(name, false);
    }

    public static void startTracing(String name, boolean customName) {
        TraceMachine.startTracing(name, false, false);
    }

    public static void startTracing(String name, boolean customName, boolean customInteraction) {
        try {
            if (!TraceMachine.isEnabled()) {
                return;
            }
            if (!customInteraction && !FeatureFlag.featureEnabled(FeatureFlag.DefaultInteractions)) {
                return;
            }
            if (!Harvest.shouldCollectActivityTraces()) {
                return;
            }
            if (TraceMachine.isTracingActive()) {
                traceMachine.completeActivityTrace();
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.set(new TraceStack());
            Trace rootTrace = new Trace();
            rootTrace.displayName = customName ? name : TraceMachine.formatActivityDisplayName(name);
            rootTrace.metricName = TraceMachine.formatActivityMetricName(rootTrace.displayName);
            rootTrace.metricBackgroundName = TraceMachine.formatActivityBackgroundMetricName(rootTrace.displayName);
            rootTrace.entryTimestamp = System.currentTimeMillis();
            if (log.getLevel() == 5) {
                log.debug("Started trace of " + name + ":" + rootTrace.myUUID.toString());
            }
            rootTrace.traceMachine = traceMachine = new TraceMachine(rootTrace);
            TraceMachine.pushTraceContext(rootTrace);
            TraceMachine.traceMachine.activityTrace.previousActivity = TraceMachine.getLastActivitySighting();
            activityHistory.add(new ActivitySighting(rootTrace.entryTimestamp, rootTrace.displayName));
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onTraceStart(TraceMachine.traceMachine.activityTrace);
            }
        }
        catch (Exception e) {
            log.error("Caught error while initializing TraceMachine, shutting it down", e);
            AgentHealth.noticeException(e);
            traceMachine = null;
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
        }
    }

    public static void haltTracing() {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        TraceMachine finishedMachine = traceMachine;
        traceMachine = null;
        finishedMachine.activityTrace.discard();
        TraceMachine.endLastActivitySighting();
        Harvest.removeHarvestListener(finishedMachine);
        threadLocalTrace.remove();
        threadLocalTraceStack.remove();
    }

    public static void endTrace() {
        traceMachine.completeActivityTrace();
    }

    public static void endTrace(String id) {
        try {
            if (TraceMachine.getActivityTrace().rootTrace.myUUID.toString().equals(id)) {
                traceMachine.completeActivityTrace();
            }
        }
        catch (TracingInactiveException tracingInactiveException) {
            // empty catch block
        }
    }

    public static String formatActivityMetricName(String name) {
        return ACTIVITY_METRIC_PREFIX + name;
    }

    public static String formatActivityBackgroundMetricName(String name) {
        return ACTIVITY_BACKGROUND_METRIC_PREFIX + name;
    }

    public static String formatActivityDisplayName(String name) {
        return ACTIVTY_DISPLAY_NAME_PREFIX + name;
    }

    private static Trace registerNewTrace(String name) throws TracingInactiveException {
        if (TraceMachine.isTracingInactive()) {
            log.debug("Tried to register a new trace but tracing is inactive!");
            throw new TracingInactiveException();
        }
        Trace parentTrace = TraceMachine.getCurrentTrace();
        Trace childTrace = new Trace(name, parentTrace.myUUID, traceMachine);
        try {
            TraceMachine.traceMachine.activityTrace.addTrace(childTrace);
        }
        catch (Exception e) {
            throw new TracingInactiveException();
        }
        if (log.getLevel() == 4) {
            log.verbose("Registering trace of " + name + " with parent " + parentTrace.displayName);
        }
        parentTrace.addChild(childTrace);
        return childTrace;
    }

    protected void completeActivityTrace() {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        TraceMachine finishedMachine = traceMachine;
        traceMachine = null;
        finishedMachine.activityTrace.complete();
        TraceMachine.endLastActivitySighting();
        for (TraceLifecycleAware listener : traceListeners) {
            listener.onTraceComplete(finishedMachine.activityTrace);
        }
        Harvest.removeHarvestListener(finishedMachine);
    }

    public static void enterNetworkSegment(String name) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            Trace currentTrace = TraceMachine.getCurrentTrace();
            if (currentTrace.getType() == TraceType.NETWORK) {
                TraceMachine.exitMethod();
            }
            TraceMachine.enterMethod(null, name, null);
            Trace networkTrace = TraceMachine.getCurrentTrace();
            networkTrace.setType(TraceType.NETWORK);
        }
        catch (TracingInactiveException e) {
        }
        catch (Exception e) {
            log.error("Caught error while calling enterNetworkSegment()", e);
            AgentHealth.noticeException(e);
        }
    }

    public static void enterMethod(String name) {
        TraceMachine.enterMethod(null, name, null);
    }

    public static void enterMethod(String name, ArrayList<String> annotationParams) {
        TraceMachine.enterMethod(null, name, annotationParams);
    }

    public static void enterMethod(Trace trace, String name, ArrayList<String> annotationParams) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            long lastUpdatedAt = TraceMachine.traceMachine.activityTrace.lastUpdatedAt;
            long inception = TraceMachine.traceMachine.activityTrace.startedAt;
            if (lastUpdatedAt + 500L < currentTime && !TraceMachine.traceMachine.activityTrace.hasMissingChildren()) {
                log.debug("Completing activity trace after hitting healthy timeout (500ms)");
                traceMachine.completeActivityTrace();
                return;
            }
            if (inception + 60000L < currentTime) {
                log.debug("Completing activity trace after hitting unhealthy timeout (60000ms)");
                traceMachine.completeActivityTrace();
                return;
            }
            TraceMachine.loadTraceContext(trace);
            Trace childTrace = TraceMachine.registerNewTrace(name);
            TraceMachine.pushTraceContext(childTrace);
            childTrace.scope = TraceMachine.getCurrentScope();
            childTrace.setAnnotationParams(annotationParams);
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onEnterMethod();
            }
            childTrace.entryTimestamp = System.currentTimeMillis();
        }
        catch (TracingInactiveException e) {
        }
        catch (Exception e) {
            log.error("Caught error while calling enterMethod()", e);
            AgentHealth.noticeException(e);
        }
    }

    public static void exitMethod() {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            Trace trace = threadLocalTrace.get();
            if (trace == null) {
                log.debug("threadLocalTrace is null");
                return;
            }
            trace.exitTimestamp = System.currentTimeMillis();
            if (trace.threadId == 0L && traceMachineInterface != null) {
                trace.threadId = traceMachineInterface.getCurrentThreadId();
                trace.threadName = traceMachineInterface.getCurrentThreadName();
            }
            for (TraceLifecycleAware listener : traceListeners) {
                listener.onExitMethod();
            }
            try {
                trace.complete();
            }
            catch (TracingInactiveException e) {
                threadLocalTrace.remove();
                threadLocalTraceStack.remove();
                if (trace.getType() == TraceType.TRACE) {
                    TaskQueue.queue(trace);
                }
                return;
            }
            threadLocalTraceStack.get().pop();
            if (threadLocalTraceStack.get().empty()) {
                threadLocalTrace.set(null);
            } else {
                Trace parentTrace = (Trace)threadLocalTraceStack.get().peek();
                threadLocalTrace.set(parentTrace);
                parentTrace.childExclusiveTime += trace.getDurationAsMilliseconds();
            }
            if (trace.getType() == TraceType.TRACE) {
                TaskQueue.queue(trace);
            }
        }
        catch (Exception e) {
            log.error("Caught error while calling exitMethod()", e);
            AgentHealth.noticeException(e);
        }
    }

    private static void pushTraceContext(Trace trace) {
        if (TraceMachine.isTracingInactive() || trace == null) {
            return;
        }
        TraceStack traceStack = threadLocalTraceStack.get();
        if (traceStack.empty()) {
            traceStack.push(trace);
        } else if (traceStack.peek() != trace) {
            traceStack.push(trace);
        }
        threadLocalTrace.set(trace);
    }

    private static void loadTraceContext(Trace trace) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        if (threadLocalTrace.get() == null) {
            threadLocalTrace.set(trace);
            threadLocalTraceStack.set(new TraceStack());
            if (trace == null) {
                return;
            }
            threadLocalTraceStack.get().push(trace);
        } else if (trace == null) {
            if (threadLocalTraceStack.get().isEmpty()) {
                if (log.getLevel() == 5) {
                    log.debug("No context to load!");
                }
                threadLocalTrace.set(null);
                return;
            }
            trace = (Trace)threadLocalTraceStack.get().peek();
            threadLocalTrace.set(trace);
        }
        if (log.getLevel() == 4) {
            log.verbose("Trace " + trace.myUUID.toString() + " is now active");
        }
    }

    public static void unloadTraceContext(Object object) {
        try {
            if (TraceMachine.isTracingInactive()) {
                return;
            }
            if (traceMachineInterface != null && traceMachineInterface.isUIThread()) {
                return;
            }
            if (threadLocalTrace.get() != null && log.getLevel() == 4) {
                log.verbose("Trace " + TraceMachine.threadLocalTrace.get().myUUID.toString() + " is now inactive");
            }
            threadLocalTrace.remove();
            threadLocalTraceStack.remove();
            try {
                TraceFieldInterface tfi = (TraceFieldInterface)object;
                tfi._nr_setTrace(null);
            }
            catch (ClassCastException e) {
                ExceptionHelper.recordSupportabilityMetric(e, "TraceFieldInterface");
                log.error("Not a TraceFieldInterface: " + e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Caught error while calling unloadTraceContext()", e);
            AgentHealth.noticeException(e);
        }
    }

    public static Trace getCurrentTrace() throws TracingInactiveException {
        if (TraceMachine.isTracingInactive()) {
            throw new TracingInactiveException();
        }
        Trace trace = threadLocalTrace.get();
        if (trace != null) {
            return trace;
        }
        return TraceMachine.getRootTrace();
    }

    public static Map<String, Object> getCurrentTraceParams() throws TracingInactiveException {
        return TraceMachine.getCurrentTrace().getParams();
    }

    public static void setCurrentTraceParam(String key, Object value) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            TraceMachine.getCurrentTrace().getParams().put(key, value);
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    public static void setCurrentDisplayName(String name) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            TraceMachine.getCurrentTrace().displayName = name;
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    public static void setRootDisplayName(String name) {
        if (TraceMachine.isTracingInactive()) {
            return;
        }
        try {
            Trace rootTrace = TraceMachine.getRootTrace();
            Measurements.renameActivity(rootTrace.displayName, name);
            TraceMachine.renameActivityHistory(rootTrace.displayName, name);
            rootTrace.metricName = TraceMachine.formatActivityMetricName(name);
            rootTrace.metricBackgroundName = TraceMachine.formatActivityBackgroundMetricName(name);
            rootTrace.displayName = name;
            Trace currentTrace = TraceMachine.getCurrentTrace();
            currentTrace.scope = TraceMachine.getCurrentScope();
        }
        catch (TracingInactiveException e) {
            return;
        }
    }

    private static void renameActivityHistory(String oldName, String newName) {
        for (ActivitySighting activitySighting : activityHistory) {
            if (!activitySighting.getName().equals(oldName)) continue;
            activitySighting.setName(newName);
        }
    }

    public static String getCurrentScope() {
        try {
            if (TraceMachine.isTracingInactive()) {
                return null;
            }
            if (traceMachineInterface == null || traceMachineInterface.isUIThread()) {
                return TraceMachine.traceMachine.activityTrace.rootTrace.metricName;
            }
            return TraceMachine.traceMachine.activityTrace.rootTrace.metricBackgroundName;
        }
        catch (Exception e) {
            log.error("Caught error while calling getCurrentScope()", e);
            AgentHealth.noticeException(e);
            return null;
        }
    }

    public static boolean isTracingActive() {
        return traceMachine != null;
    }

    public static boolean isTracingInactive() {
        return !TraceMachine.isTracingActive();
    }

    public void storeCompletedTrace(Trace trace) {
        try {
            if (TraceMachine.isTracingInactive()) {
                log.debug("Attempted to store a completed trace with no trace machine!");
                return;
            }
            this.activityTrace.addCompletedTrace(trace);
        }
        catch (Exception e) {
            log.error("Caught error while calling storeCompletedTrace()", e);
            AgentHealth.noticeException(e);
        }
    }

    public static Trace getRootTrace() throws TracingInactiveException {
        try {
            return TraceMachine.traceMachine.activityTrace.rootTrace;
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    public static ActivityTrace getActivityTrace() throws TracingInactiveException {
        try {
            return TraceMachine.traceMachine.activityTrace;
        }
        catch (NullPointerException e) {
            throw new TracingInactiveException();
        }
    }

    public static ActivityHistory getActivityHistory() {
        return new ActivityHistory(activityHistory);
    }

    public static ActivitySighting getLastActivitySighting() {
        if (activityHistory.isEmpty()) {
            return null;
        }
        return activityHistory.get(activityHistory.size() - 1);
    }

    public static void endLastActivitySighting() {
        ActivitySighting activitySighting = TraceMachine.getLastActivitySighting();
        if (activitySighting != null) {
            activitySighting.end(System.currentTimeMillis());
        }
    }

    public static void clearActivityHistory() {
        activityHistory.clear();
    }

    @Override
    public void onHarvestBefore() {
        if (TraceMachine.isTracingActive()) {
            long currentTime = System.currentTimeMillis();
            long lastUpdatedAt = TraceMachine.traceMachine.activityTrace.lastUpdatedAt;
            long inception = TraceMachine.traceMachine.activityTrace.startedAt;
            if (lastUpdatedAt + 500L < currentTime && !TraceMachine.traceMachine.activityTrace.hasMissingChildren()) {
                log.debug("Completing activity trace after hitting healthy timeout (500ms)");
                this.completeActivityTrace();
                StatsEngine.get().inc("Supportability/AgentHealth/HealthyActivityTraces");
                return;
            }
            if (inception + 60000L < currentTime) {
                log.debug("Completing activity trace after hitting unhealthy timeout (60000ms)");
                this.completeActivityTrace();
                StatsEngine.get().inc("Supportability/AgentHealth/UnhealthyActivityTraces");
                return;
            }
        } else {
            log.debug("TraceMachine is inactive");
        }
    }

    @Override
    public void onHarvestSendFailed() {
        try {
            TraceMachine.traceMachine.activityTrace.incrementReportAttemptCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static class TraceStack
    extends Stack<Trace> {
        private TraceStack() {
        }
    }
}

