/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.CrashEvent;
import com.newrelic.agent.android.analytics.CustomEvent;
import com.newrelic.agent.android.analytics.InteractionEvent;
import com.newrelic.agent.android.analytics.SessionEvent;
import java.util.Set;

public class AnalyticsEventFactory {
    static AnalyticsEvent createEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticAttribute> eventAttributes) {
        AnalyticsEvent event = null;
        switch (eventCategory) {
            case Session: {
                event = new SessionEvent(eventAttributes);
                break;
            }
            case Interaction: {
                event = new InteractionEvent(name, eventAttributes);
                break;
            }
            case Crash: {
                event = new CrashEvent(name, eventAttributes);
                break;
            }
            case Custom: {
                event = new CustomEvent(name, eventType, eventAttributes);
            }
        }
        return event;
    }

    private AnalyticsEventFactory() {
    }
}

