/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp2;

import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.util.TreeMap;
import okio.Buffer;
import okio.BufferedSource;

public class OkHttp2TransactionStateUtil
extends TransactionStateUtil {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String NO_BODY_TEXT = "Response BODY not found.";

    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        if (request == null) {
            log.warning("Missing request");
        } else {
            OkHttp2TransactionStateUtil.inspectAndInstrument(transactionState, request.urlString(), request.method());
        }
    }

    public static Response inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = "";
        int statusCode = -1;
        long contentLength = 0L;
        if (response == null) {
            statusCode = 500;
            log.warning("Missing response");
        } else {
            appData = response.header("X-NewRelic-App-Data");
            statusCode = response.code();
            try {
                contentLength = response.body().contentLength();
            }
            catch (Exception e) {
                log.warning("Missing body or content length");
            }
        }
        OkHttp2TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, (int)contentLength, statusCode);
        return OkHttp2TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    private static Response addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData != null) {
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData()));
            if ((long)transactionState.getStatusCode() >= 400L && response != null) {
                String responseBodyString;
                TreeMap<String, String> params;
                block5: {
                    String contentTypeHeader = response.header("Content-Type");
                    Object contentType = null;
                    params = new TreeMap<String, String>();
                    if (contentTypeHeader != null && contentTypeHeader.length() > 0 && !"".equals(contentTypeHeader)) {
                        params.put("content_type", (String)contentType);
                    }
                    params.put("content_length", transactionState.getBytesReceived() + "");
                    responseBodyString = "";
                    try {
                        final ResponseBody body = response.body();
                        responseBodyString = body.string();
                        final Buffer contents = new Buffer().write(responseBodyString.getBytes());
                        ResponseBody responseBody = new ResponseBody(){

                            public MediaType contentType() {
                                return body.contentType();
                            }

                            public long contentLength() {
                                return contents.size();
                            }

                            public BufferedSource source() {
                                return contents;
                            }
                        };
                        response = response.newBuilder().body(responseBody).build();
                    }
                    catch (Exception e) {
                        if (response.message() == null) break block5;
                        log.warning("Missing response body, using response message");
                        responseBodyString = response.message();
                    }
                }
                Measurements.addHttpError(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), responseBodyString, params);
            }
        }
        return response;
    }
}

