/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.analytics.AnalyticAttribute;
import com.newrelic.agent.android.analytics.AnalyticAttributeStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedPrefsAnalyticAttributeStore
implements AnalyticAttributeStore {
    private static final String STORE_FILE = "NRAnalyticAttributeStore";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final Context context;

    public SharedPrefsAnalyticAttributeStore(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(AnalyticAttribute attribute) {
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            if (attribute.isPersistent()) {
                SharedPreferences preferences = this.context.getSharedPreferences(STORE_FILE, 0);
                SharedPreferences.Editor editor = preferences.edit();
                switch (attribute.getAttributeDataType()) {
                    case STRING: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getStringValue());
                        editor.putString(attribute.getName(), attribute.getStringValue());
                        break;
                    }
                    case FLOAT: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getFloatValue());
                        editor.putFloat(attribute.getName(), attribute.getFloatValue());
                        break;
                    }
                    case BOOLEAN: {
                        log.verbose("SharedPrefsAnalyticAttributeStore.store - storing analytic attribute " + attribute.getName() + "=" + attribute.getBooleanValue());
                        editor.putBoolean(attribute.getName(), attribute.getBooleanValue());
                        break;
                    }
                    default: {
                        log.error("SharedPrefsAnalyticAttributeStore.store - unsupported analytic attribute data type" + attribute.getName());
                    }
                }
                return editor.commit();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnalyticAttribute> fetchAll() {
        log.verbose("SharedPrefsAnalyticAttributeStore.fetchAll invoked.");
        SharedPreferences preferences = this.context.getSharedPreferences(STORE_FILE, 0);
        ArrayList<AnalyticAttribute> analyticAttributeArrayList = new ArrayList<AnalyticAttribute>();
        Map storedAttributes = null;
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            storedAttributes = preferences.getAll();
        }
        for (Map.Entry entry : storedAttributes.entrySet()) {
            log.debug("SharedPrefsAnalyticAttributeStore.fetchAll - found analytic attribute " + entry.getKey() + "=" + entry.getValue());
            if (entry.getValue() instanceof String) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), entry.getValue().toString(), true));
                continue;
            }
            if (entry.getValue() instanceof Float) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), Float.valueOf(entry.getValue().toString()).floatValue(), true));
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                analyticAttributeArrayList.add(new AnalyticAttribute(entry.getKey().toString(), Boolean.valueOf(entry.getValue().toString()), true));
                continue;
            }
            log.error("SharedPrefsAnalyticAttributeStore.fetchAll - unsupported analytic attribute " + entry.getKey() + "=" + entry.getValue());
        }
        return analyticAttributeArrayList;
    }

    @Override
    public int count() {
        SharedPreferences preferences = this.context.getSharedPreferences(STORE_FILE, 0);
        int size = preferences.getAll().size();
        log.verbose("SharedPrefsAnalyticAttributeStore.count - returning " + size);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        log.verbose("SharedPrefsAnalyticAttributeStore.clear - flushing stored attributes");
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            SharedPreferences preferences = this.context.getSharedPreferences(STORE_FILE, 0);
            preferences.edit().clear().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(AnalyticAttribute attribute) {
        SharedPrefsAnalyticAttributeStore sharedPrefsAnalyticAttributeStore = this;
        synchronized (sharedPrefsAnalyticAttributeStore) {
            log.verbose("SharedPrefsAnalyticAttributeStore.delete - deleting attribute " + attribute.getName());
            SharedPreferences preferences = this.context.getSharedPreferences(STORE_FILE, 0);
            preferences.edit().remove(attribute.getName()).commit();
        }
    }
}

